/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.contributor.document;

import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DocumentContributor.class})
public class AuditedModelDocumentContributor
implements DocumentContributor {
    @Reference
    protected Portal portal;

    public void contribute(Document document, BaseModel baseModel) {
        if (!(baseModel instanceof AuditedModel)) {
            return;
        }
        AuditedModel auditedModel = (AuditedModel)baseModel;
        document.addKeyword("companyId", auditedModel.getCompanyId());
        document.addDate("createDate", auditedModel.getCreateDate());
        document.addDate("modified", auditedModel.getModifiedDate());
        document.addKeyword("userId", auditedModel.getUserId());
        String userName = this.portal.getUserName(auditedModel.getUserId(), auditedModel.getUserName());
        document.addKeyword("userName", userName, true);
    }
}

