/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.contributor.document;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DocumentContributor.class})
public class AssetTagDocumentContributor
implements DocumentContributor {
    @Reference
    protected AssetTagLocalService assetTagLocalService;
    protected Localization localization;
    @Reference
    protected Portal portal;

    public void contribute(Document document, BaseModel baseModel) {
        long classPK;
        String className = document.get("entryClassName");
        long classNameId = this.portal.getClassNameId(className);
        List assetTags = this.assetTagLocalService.getTags(classNameId, classPK = GetterUtil.getLong((String)document.get("entryClassPK")));
        if (ListUtil.isEmpty((List)assetTags)) {
            return;
        }
        this.contributeAssetTagIds(document, assetTags);
        this.contributeAssetTagNamesLocalized(document, assetTags, baseModel);
        this.contributeAssetTagNamesRaw(document, assetTags);
    }

    protected void contributeAssetTagIds(Document document, List<AssetTag> assetTags) {
        document.addKeyword("assetTagIds", this.getTagIds(assetTags));
    }

    protected void contributeAssetTagNamesLocalized(Document document, List<AssetTag> assetTags, BaseModel baseModel) {
        Long groupId = this.getGroupId(baseModel);
        if (groupId == null) {
            return;
        }
        Localization localization = this.getLocalization();
        document.addText(localization.getLocalizedName("assetTagNames", LocaleUtil.toLanguageId((Locale)this.getSiteDefaultLocale(groupId))), this.getNames(assetTags));
    }

    protected void contributeAssetTagNamesRaw(Document document, List<AssetTag> assetTags) {
        document.addText("assetTagNames", this.getNames(assetTags));
    }

    protected Long getGroupId(BaseModel baseModel) {
        if (baseModel instanceof GroupedModel) {
            return ((GroupedModel)baseModel).getGroupId();
        }
        if (baseModel instanceof User) {
            return ((User)baseModel).getGroupId();
        }
        return null;
    }

    protected Localization getLocalization() {
        if (this.localization != null) {
            return this.localization;
        }
        return LocalizationUtil.getLocalization();
    }

    protected String[] getNames(List<AssetTag> assetTags) {
        Stream stream = assetTags.stream();
        return (String[])stream.map(AssetTagModel::getName).toArray(String[]::new);
    }

    protected Locale getSiteDefaultLocale(long groupId) {
        try {
            return this.portal.getSiteDefaultLocale(groupId);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    protected Long[] getTagIds(List<AssetTag> assetTags) {
        Stream stream = assetTags.stream();
        return (Long[])stream.map(AssetTagModel::getTagId).toArray(Long[]::new);
    }
}

