/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.contributor.document;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DocumentContributor.class})
public class AssetEntryDocumentContributor
implements DocumentContributor {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;

    public void contribute(Document document, BaseModel baseModel) {
        String className = document.get("entryClassName");
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null || !assetRendererFactory.isSelectable()) {
            return;
        }
        long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(className, classPK);
        if (assetEntry == null) {
            return;
        }
        if (!document.hasField("createDate")) {
            document.addDate("createDate", assetEntry.getCreateDate());
        }
        if (assetEntry.getExpirationDate() != null) {
            document.addDate("expirationDate", assetEntry.getExpirationDate());
        } else {
            document.addDate("expirationDate", new Date(Long.MAX_VALUE));
        }
        if (!document.hasField("modified")) {
            document.addDate("modified", assetEntry.getModifiedDate());
        }
        document.addNumber("priority", assetEntry.getPriority());
        if (assetEntry.getPublishDate() != null) {
            document.addDate("publishDate", assetEntry.getPublishDate());
        } else {
            document.addDate("publishDate", new Date(0L));
        }
        document.addLocalizedKeyword("localized_title", this.populateMap(assetEntry, assetEntry.getTitleMap()), true, true);
        document.addKeyword("visible", assetEntry.isVisible());
    }

    protected Map<Locale, String> populateMap(AssetEntry assetEntry, Map<Locale, String> map) {
        String defaultValue = map.get(LocaleUtil.fromLanguageId((String)assetEntry.getDefaultLanguageId()));
        for (Locale availableLocale : LanguageUtil.getAvailableLocales((long)assetEntry.getGroupId())) {
            if (map.containsKey(availableLocale) && !Validator.isNull((String)map.get(availableLocale))) continue;
            map.put(availableLocale, defaultValue);
        }
        return map;
    }
}

