/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.contributor.document;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DocumentContributor.class})
public class AssetCategoryDocumentContributor
implements DocumentContributor {
    @Reference
    protected AssetCategoryLocalService assetCategoryLocalService;

    public void contribute(Document document, BaseModel baseModel) {
        String className = document.get("entryClassName");
        long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
        List assetCategories = this.assetCategoryLocalService.getCategories(className, classPK);
        long[] assetCategoryIds = ListUtil.toLongArray((List)assetCategories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        this.addAssetCategoryTitles(document, "assetCategoryTitles", assetCategories);
    }

    protected void addAssetCategoryTitles(Document document, String field, List<AssetCategory> assetCategories) {
        HashMap<Locale, List> assetCategoryTitles = new HashMap<Locale, List>();
        for (AssetCategory assetCategory : assetCategories) {
            Map titleMap = assetCategory.getTitleMap();
            for (Map.Entry entry : titleMap.entrySet()) {
                String title = (String)entry.getValue();
                if (Validator.isNull((String)title)) continue;
                Locale locale = (Locale)entry.getKey();
                List titles = assetCategoryTitles.computeIfAbsent(locale, k -> new ArrayList());
                titles.add(StringUtil.toLowerCase((String)title));
            }
        }
        for (Map.Entry entry : assetCategoryTitles.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            List titles = (List)entry.getValue();
            String[] titlesArray = titles.toArray(new String[titles.size()]);
            document.addText(field.concat("_").concat(locale.toString()), titlesArray);
        }
    }
}

