/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.buffer;

import com.liferay.portal.search.buffer.IndexerRequest;
import com.liferay.portal.search.buffer.IndexerRequestBuffer;
import com.liferay.portal.search.buffer.IndexerRequestBufferOverflowHandler;
import com.liferay.portal.search.configuration.IndexerRegistryConfiguration;
import com.liferay.portal.search.internal.buffer.BufferOverflowThreadLocal;

public class IndexerRequestBufferHandler {
    private final IndexerRegistryConfiguration _indexerRegistryConfiguration;
    private final IndexerRequestBufferOverflowHandler _indexerRequestBufferOverflowHandler;

    public IndexerRequestBufferHandler(IndexerRequestBufferOverflowHandler indexerRequestBufferOverflowHandler, IndexerRegistryConfiguration indexerRegistryConfiguration) {
        this._indexerRequestBufferOverflowHandler = indexerRequestBufferOverflowHandler;
        this._indexerRegistryConfiguration = indexerRegistryConfiguration;
    }

    public void bufferRequest(IndexerRequest indexerRequest, IndexerRequestBuffer indexerRequestBuffer) throws Exception {
        if (!BufferOverflowThreadLocal.isOverflowMode()) {
            int maxBufferSize = this._indexerRegistryConfiguration.maxBufferSize();
            indexerRequestBuffer.add(indexerRequest, this._indexerRequestBufferOverflowHandler, maxBufferSize);
        } else {
            indexerRequest.execute();
        }
    }
}

