/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.buffer;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.buffer.IndexerRequestBufferExecutor;
import com.liferay.portal.search.configuration.IndexerRegistryConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.search.configuration.IndexerRegistryConfiguration"}, immediate=true, service={IndexerRequestBufferExecutorWatcher.class})
public class IndexerRequestBufferExecutorWatcher {
    private static final Log _log = LogFactoryUtil.getLog(IndexerRequestBufferExecutorWatcher.class);
    @Reference(target="(buffered.execution.mode=DEFAULT)")
    private IndexerRequestBufferExecutor _defaultIndexerRequestBufferExecutor;
    private IndexerRegistryConfiguration _indexerRegistryConfiguration;
    private final Map<String, IndexerRequestBufferExecutor> _indexerRequestBufferExecutors = new ConcurrentHashMap<String, IndexerRequestBufferExecutor>();

    public IndexerRequestBufferExecutor getIndexerRequestBufferExecutor() {
        String bufferedExecutionMode = this._indexerRegistryConfiguration.bufferedExecutionMode();
        IndexerRequestBufferExecutor indexerRequestBufferExecutor = this._indexerRequestBufferExecutors.get(bufferedExecutionMode);
        if (indexerRequestBufferExecutor == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using default indexer request buffered executor for " + bufferedExecutionMode));
            }
            indexerRequestBufferExecutor = this._defaultIndexerRequestBufferExecutor;
        }
        return indexerRequestBufferExecutor;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._indexerRegistryConfiguration = (IndexerRegistryConfiguration)ConfigurableUtil.createConfigurable(IndexerRegistryConfiguration.class, properties);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addIndexerRequestBufferExecutor(IndexerRequestBufferExecutor indexerRequestBufferExecutor, Map<String, Object> properties) {
        String bufferedExecutionMode = this._getBufferedExecutionMode(properties);
        this._indexerRequestBufferExecutors.put(bufferedExecutionMode, indexerRequestBufferExecutor);
    }

    protected void removeIndexerRequestBufferExecutor(IndexerRequestBufferExecutor indexerRequestBufferExecutor, Map<String, Object> properties) {
        String bufferedExecutionMode = this._getBufferedExecutionMode(properties);
        this._indexerRequestBufferExecutors.remove(bufferedExecutionMode);
    }

    private String _getBufferedExecutionMode(Map<String, Object> properties) {
        String bufferedExecutionMode = GetterUtil.getString((Object)properties.get("buffered.execution.mode"));
        if (Validator.isNull((String)bufferedExecutionMode)) {
            throw new IllegalArgumentException("The property \"buffered.execution.mode\" is invalid for " + ClassUtil.getClassName((Object)bufferedExecutionMode));
        }
        return bufferedExecutionMode;
    }
}

