/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.buffer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.search.buffer.IndexerRequest;
import com.liferay.portal.search.buffer.IndexerRequestBuffer;
import com.liferay.portal.search.buffer.IndexerRequestBufferExecutor;
import com.liferay.portal.search.internal.buffer.BaseIndexerRequestBufferExecutor;
import com.liferay.portal.search.internal.buffer.BufferOverflowThreadLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;

@Component(immediate=true, property={"buffered.execution.mode=DEFAULT"}, service={IndexerRequestBufferExecutor.class})
public class DefaultIndexerRequestBufferExecutor
extends BaseIndexerRequestBufferExecutor
implements IndexerRequestBufferExecutor {
    private static final Log _log = LogFactoryUtil.getLog(DefaultIndexerRequestBufferExecutor.class);
    private ServiceTracker<IndexWriterHelper, IndexWriterHelper> _indexWriterHelperServiceTracker;

    public void execute(IndexerRequestBuffer indexerRequestBuffer, int numRequests) {
        HashSet<String> searchEngineIds = new HashSet<String>();
        ArrayList<IndexerRequest> completedIndexerRequests = new ArrayList<IndexerRequest>();
        if (_log.isDebugEnabled()) {
            Collection indexerRequests = indexerRequestBuffer.getIndexerRequests();
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Indexer request buffer size ", indexerRequests.size(), " to execute ", numRequests, " requests"}));
        }
        int i = 0;
        for (IndexerRequest indexerRequest : indexerRequestBuffer.getIndexerRequests()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Executing indexer request ", i++, ": ", indexerRequest}));
            }
            this.executeIndexerRequest(searchEngineIds, indexerRequest);
            completedIndexerRequests.add(indexerRequest);
            if (completedIndexerRequests.size() != numRequests) continue;
            break;
        }
        for (IndexerRequest indexerRequest : completedIndexerRequests) {
            indexerRequestBuffer.remove(indexerRequest);
        }
        if (!BufferOverflowThreadLocal.isOverflowMode()) {
            this.commit(searchEngineIds);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._indexWriterHelperServiceTracker = new ServiceTracker(bundleContext, IndexWriterHelper.class, null);
        this._indexWriterHelperServiceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._indexWriterHelperServiceTracker.close();
    }

    @Override
    protected IndexWriterHelper getIndexWriterHelper() {
        return (IndexWriterHelper)this._indexWriterHelperServiceTracker.getService();
    }
}

