/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.buffer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.search.buffer.IndexerRequest;
import com.liferay.portal.search.buffer.IndexerRequestBuffer;
import com.liferay.portal.search.buffer.IndexerRequestBufferExecutor;
import java.util.Set;

public abstract class BaseIndexerRequestBufferExecutor
implements IndexerRequestBufferExecutor {
    private static final Log _log = LogFactoryUtil.getLog(BaseIndexerRequestBufferExecutor.class);

    public void execute(IndexerRequestBuffer indexerRequestBuffer) {
        this.execute(indexerRequestBuffer, indexerRequestBuffer.size());
    }

    protected void commit(Set<String> searchEngineIds) {
        IndexWriterHelper indexWriterHelper = this.getIndexWriterHelper();
        if (indexWriterHelper == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Index writer helper is null");
            }
            return;
        }
        for (String searchEngineId : searchEngineIds) {
            try {
                indexWriterHelper.commit(searchEngineId);
            }
            catch (SearchException se) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)"Unable to commit search engine", (Throwable)se);
            }
        }
    }

    protected void executeIndexerRequest(Set<String> searchEngineIds, IndexerRequest indexerRequest) {
        block2: {
            try {
                indexerRequest.execute();
                searchEngineIds.add(indexerRequest.getSearchEngineId());
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to execute index request " + indexerRequest), (Throwable)e);
            }
        }
    }

    protected abstract IndexWriterHelper getIndexWriterHelper();
}

