/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.background.task;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.background.task.ReindexStatusMessageSenderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.background.task.ReindexBackgroundTaskExecutor;
import java.util.Map;

public class ReindexSingleIndexerBackgroundTaskExecutor
extends ReindexBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(ReindexSingleIndexerBackgroundTaskExecutor.class);

    public ReindexSingleIndexerBackgroundTaskExecutor() {
        this.setIsolationLevel(5);
    }

    public BackgroundTaskExecutor clone() {
        return new ReindexSingleIndexerBackgroundTaskExecutor();
    }

    public String generateLockKey(BackgroundTask backgroundTask) {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        String className = (String)taskContextMap.get("className");
        if (Validator.isNotNull((String)className)) {
            return className;
        }
        return super.generateLockKey(backgroundTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reindex(String className, long[] companyIds) throws Exception {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)className);
        if (indexer == null) {
            return;
        }
        for (long companyId : companyIds) {
            ReindexStatusMessageSenderUtil.sendStatusMessage((String)"singleStart", (long)companyId, (long[])companyIds);
            try {
                IndexWriterHelperUtil.deleteEntityDocuments((String)indexer.getSearchEngineId(), (long)companyId, (String)className, (boolean)true);
                indexer.reindex(new String[]{String.valueOf(companyId)});
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            finally {
                ReindexStatusMessageSenderUtil.sendStatusMessage((String)"singleEnd", (long)companyId, (long[])companyIds);
            }
        }
    }
}

