/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.background.task;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.background.task.ReindexStatusMessageSenderUtil;
import com.liferay.portal.search.internal.SearchEngineInitializer;
import com.liferay.portal.search.internal.background.task.ReindexBackgroundTaskExecutor;

public class ReindexPortalBackgroundTaskExecutor
extends ReindexBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(ReindexPortalBackgroundTaskExecutor.class);
    private final PortalExecutorManager _portalExecutorManager;

    public ReindexPortalBackgroundTaskExecutor(PortalExecutorManager portalExecutorManager) {
        this._portalExecutorManager = portalExecutorManager;
    }

    public BackgroundTaskExecutor clone() {
        return new ReindexPortalBackgroundTaskExecutor(this._portalExecutorManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reindex(String className, long[] companyIds) throws Exception {
        for (long companyId : companyIds) {
            ReindexStatusMessageSenderUtil.sendStatusMessage((String)"portalStart", (long)companyId, (long[])companyIds);
            try {
                SearchEngineInitializer searchEngineInitializer = new SearchEngineInitializer(companyId, this._portalExecutorManager);
                searchEngineInitializer.reindex();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            finally {
                ReindexStatusMessageSenderUtil.sendStatusMessage((String)"portalEnd", (long)companyId, (long[])companyIds);
            }
        }
    }
}

