/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.background.task;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.search.internal.background.task.ReindexPortalBackgroundTaskExecutor;
import com.liferay.portal.search.internal.background.task.ReindexSingleIndexerBackgroundTaskExecutor;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BackgroundTaskExecutorConfigurator.class})
public class BackgroundTaskExecutorConfigurator {
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    private final Set<ServiceRegistration<BackgroundTaskExecutor>> _serviceRegistrations = new HashSet<ServiceRegistration<BackgroundTaskExecutor>>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        ReindexPortalBackgroundTaskExecutor reindexPortalBackgroundTaskExecutor = new ReindexPortalBackgroundTaskExecutor(this._portalExecutorManager);
        this.registerBackgroundTaskExecutor(bundleContext, (BackgroundTaskExecutor)reindexPortalBackgroundTaskExecutor);
        ReindexSingleIndexerBackgroundTaskExecutor reindexSingleIndexerBackgroundTaskExecutor = new ReindexSingleIndexerBackgroundTaskExecutor();
        this.registerBackgroundTaskExecutor(bundleContext, (BackgroundTaskExecutor)reindexSingleIndexerBackgroundTaskExecutor);
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<BackgroundTaskExecutor> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    protected void registerBackgroundTaskExecutor(BundleContext bundleContext, BackgroundTaskExecutor backgroundTaskExecutor) {
        HashMapDictionary properties = new HashMapDictionary();
        Class<?> clazz = backgroundTaskExecutor.getClass();
        properties.put("background.task.executor.class.name", clazz.getName());
        ServiceRegistration serviceRegistration = bundleContext.registerService(BackgroundTaskExecutor.class, (Object)backgroundTaskExecutor, (Dictionary)properties);
        this._serviceRegistrations.add((ServiceRegistration<BackgroundTaskExecutor>)serviceRegistration);
    }
}

