/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.analysis;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.analysis.KeywordTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={KeywordTokenizer.class})
public class SimpleKeywordTokenizer
implements KeywordTokenizer {
    private static final char _IDEOGRAPHIC_SPACE = '\u3000';

    public boolean requiresTokenization(String keyword) {
        int start = keyword.indexOf(34);
        int end = keyword.indexOf(34, start + 1);
        return (keyword.indexOf(34) != 0 || keyword.lastIndexOf(34) != keyword.length() - 1) && (start > -1 && end > start || start == -1 && end == -1 && keyword.indexOf(32) != -1);
    }

    public List<String> tokenize(String keyword) {
        keyword = this._normalizeWhitespace(keyword);
        ArrayList<String> tokens = new ArrayList<String>();
        int start = keyword.indexOf(34);
        int end = keyword.indexOf(34, start + 1);
        this.tokenize(keyword, tokens, start, end);
        return tokens;
    }

    protected String[] split(String keyword) {
        if (Objects.equals(keyword, "null")) {
            return new String[]{keyword};
        }
        return StringUtil.split((String)keyword, (char)' ');
    }

    protected void tokenize(String keyword, List<String> tokens, int start, int end) {
        if (start == -1 || end == -1) {
            if (!(keyword = keyword.trim()).isEmpty()) {
                this.tokenizeBySpace(keyword, tokens);
            }
            return;
        }
        String token = keyword.substring(0, start);
        if (!(token = token.trim()).isEmpty()) {
            this.tokenizeBySpace(token, tokens);
        }
        token = keyword.substring(start, end + 1);
        if (!(token = token.trim()).isEmpty()) {
            tokens.add(token);
        }
        if (end + 1 > keyword.length()) {
            return;
        }
        keyword = keyword.substring(end + 1);
        if ((keyword = keyword.trim()).isEmpty()) {
            return;
        }
        start = keyword.indexOf(34);
        end = keyword.indexOf(34, start + 1);
        this.tokenize(keyword, tokens, start, end);
    }

    protected void tokenizeBySpace(String keyword, List<String> tokens) {
        String[] keywordTokens;
        for (String keywordToken : keywordTokens = this.split(keyword)) {
            keyword = keywordToken.trim();
            if (keyword.isEmpty()) continue;
            tokens.add(keyword);
        }
    }

    private String _normalizeWhitespace(String keyword) {
        return StringUtil.replace((String)keyword, (char)'\u3000', (char)' ');
    }
}

