/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.analysis;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.analysis.KeywordTokenizer;
import com.liferay.portal.search.internal.analysis.PhraseQueryBuilder;
import java.util.ArrayList;
import java.util.List;

public class FullTextQueryBuilder {
    private boolean _autocomplete;
    private float _exactMatchBoost;
    private final KeywordTokenizer _keywordTokenizer;
    private Integer _proximitySlop;

    public FullTextQueryBuilder(KeywordTokenizer keywordTokenizer) {
        this._keywordTokenizer = keywordTokenizer;
    }

    public Query build(String field, String keywords) {
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        List tokens = this._keywordTokenizer.tokenize(keywords);
        ArrayList<String> phrases = new ArrayList<String>(tokens.size());
        ArrayList<String> words = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            if (StringUtil.startsWith((String)token, (char)'\"')) {
                phrases.add(StringUtil.unquote((String)token));
                continue;
            }
            words.add(token);
        }
        for (String phrase : phrases) {
            booleanQueryImpl.add(this.createPhraseQuery(field, phrase), BooleanClauseOccur.MUST);
        }
        if (!words.isEmpty()) {
            this.addSentenceQueries(field, StringUtil.merge(words, (String)" "), booleanQueryImpl);
        }
        booleanQueryImpl.add(this.createExactMatchQuery(field, keywords), BooleanClauseOccur.SHOULD);
        return booleanQueryImpl;
    }

    public void setAutocomplete(boolean autocomplete) {
        this._autocomplete = autocomplete;
    }

    public void setExactMatchBoost(float exactMatchBoost) {
        this._exactMatchBoost = exactMatchBoost;
    }

    public void setProximitySlop(int proximitySlop) {
        this._proximitySlop = proximitySlop;
    }

    protected void addSentenceQueries(String field, String sentence, BooleanQueryImpl booleanQueryImpl) {
        booleanQueryImpl.add(this.createMandatoryQuery(field, sentence), BooleanClauseOccur.MUST);
        if (this._proximitySlop != null) {
            booleanQueryImpl.add(this.createProximityQuery(field, sentence), BooleanClauseOccur.SHOULD);
        }
    }

    protected Query createAutocompleteQuery(String field, String value) {
        PhraseQueryBuilder builder = new PhraseQueryBuilder();
        builder.setPrefix(true);
        return builder.build(field, value);
    }

    protected Query createExactMatchQuery(String field, String keywords) {
        PhraseQueryBuilder builder = new PhraseQueryBuilder();
        builder.setBoost(this._exactMatchBoost);
        return builder.build(field, keywords);
    }

    protected Query createMandatoryQuery(String field, String sentence) {
        Query matchQuery = this.createMatchQuery(field, sentence);
        if (!this._autocomplete) {
            return matchQuery;
        }
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        booleanQueryImpl.add(matchQuery, BooleanClauseOccur.SHOULD);
        booleanQueryImpl.add(this.createAutocompleteQuery(field, sentence), BooleanClauseOccur.SHOULD);
        return booleanQueryImpl;
    }

    protected Query createMatchQuery(String field, String value) {
        return new MatchQuery(field, value);
    }

    protected Query createPhraseQuery(String field, String phrase) {
        PhraseQueryBuilder builder = new PhraseQueryBuilder();
        builder.setTrailingStarAware(true);
        return builder.build(field, phrase);
    }

    protected Query createProximityQuery(String field, String value) {
        PhraseQueryBuilder builder = new PhraseQueryBuilder();
        builder.setSlop(this._proximitySlop);
        return builder.build(field, value);
    }
}

