/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexSearcherHelper;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.SearchException;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexSearcherHelper.class})
public class IndexSearcherHelperImpl
implements IndexSearcherHelper {
    private static final Log _log = LogFactoryUtil.getLog(IndexSearcherHelperImpl.class);
    @Reference
    private SearchEngineHelper _searchEngineHelper;

    public String getQueryString(SearchContext searchContext, Query query) {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine(searchContext.getSearchEngineId());
        IndexSearcher indexSearcher = searchEngine.getIndexSearcher();
        try {
            return indexSearcher.getQueryString(searchContext, query);
        }
        catch (ParseException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to parse query " + query), (Throwable)pe);
            }
            return "";
        }
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine(searchContext.getSearchEngineId());
        IndexSearcher indexSearcher = searchEngine.getIndexSearcher();
        return indexSearcher.search(searchContext, query);
    }

    public long searchCount(SearchContext searchContext, Query query) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine(searchContext.getSearchEngineId());
        IndexSearcher indexSearcher = searchEngine.getIndexSearcher();
        return indexSearcher.searchCount(searchContext, query);
    }

    public String spellCheckKeywords(SearchContext searchContext) throws SearchException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Spell checking " + searchContext.getKeywords()));
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine(searchContext.getSearchEngineId());
        IndexSearcher indexSearcher = searchEngine.getIndexSearcher();
        return indexSearcher.spellCheckKeywords(searchContext);
    }

    public Map<String, List<String>> spellCheckKeywords(SearchContext searchContext, int max) throws SearchException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Spell checking " + searchContext.getKeywords()));
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine(searchContext.getSearchEngineId());
        IndexSearcher indexSearcher = searchEngine.getIndexSearcher();
        return indexSearcher.spellCheckKeywords(searchContext, max);
    }

    public String[] suggestKeywordQueries(SearchContext searchContext, int max) throws SearchException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Suggesting keyword queries" + searchContext.getKeywords()));
        }
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine(searchContext.getSearchEngineId());
        IndexSearcher indexSearcher = searchEngine.getIndexSearcher();
        return indexSearcher.suggestKeywordQueries(searchContext, max);
    }
}

