/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.instance.lifecycle;

import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;

public class IndexOnStartupPortalInstanceLifecycleListener
implements PortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(IndexOnStartupPortalInstanceLifecycleListener.class);
    private final String _className;
    private final ClusterMasterExecutor _clusterMasterExecutor;
    private final IndexWriterHelper _indexWriterHelper;
    private final Props _props;

    public IndexOnStartupPortalInstanceLifecycleListener(ClusterMasterExecutor clusterMasterExecutor, IndexWriterHelper indexWriterHelper, Props props, String className) {
        this._clusterMasterExecutor = clusterMasterExecutor;
        this._indexWriterHelper = indexWriterHelper;
        this._props = props;
        this._className = className;
    }

    public void portalInstancePreregistered(long companyId) {
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!GetterUtil.getBoolean((String)this._props.get("index.on.startup")) || !this._clusterMasterExecutor.isMaster()) {
            return;
        }
        try {
            this._indexWriterHelper.reindex(0L, "reindexOnActivate#" + this._className, new long[]{company.getCompanyId()}, this._className, null);
        }
        catch (SearchException se) {
            _log.error((Object)"Unable to reindex on activation", (Throwable)se);
        }
    }

    public void portalInstanceUnregistered(Company company) throws Exception {
    }
}

