/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.hits;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.hits.HitsProcessor;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"sort.order=2"}, service={HitsProcessor.class})
public class QueryIndexingHitsProcessor
implements HitsProcessor {
    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isQueryIndexingEnabled()) {
            return true;
        }
        if (hits.getLength() >= queryConfig.getQueryIndexingThreshold()) {
            this.addDocument(searchContext.getCompanyId(), searchContext.getKeywords(), searchContext.getLocale());
        }
        return true;
    }

    protected void addDocument(long companyId, String keywords, Locale locale) throws SearchException {
        IndexWriterHelperUtil.indexKeyword((long)companyId, (String)keywords, (float)0.0f, (String)"querySuggestion", (Locale)locale);
    }
}

