/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.buffer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.buffer.IndexerRequest;
import com.liferay.portal.search.buffer.IndexerRequestBuffer;
import com.liferay.portal.search.buffer.IndexerRequestBufferExecutor;
import com.liferay.portal.search.internal.buffer.BaseIndexerRequestBufferExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"buffered.execution.mode=DEFAULT"}, service={IndexerRequestBufferExecutor.class})
public class DefaultIndexerRequestBufferExecutor
extends BaseIndexerRequestBufferExecutor
implements IndexerRequestBufferExecutor {
    private static final Log _log = LogFactoryUtil.getLog(DefaultIndexerRequestBufferExecutor.class);

    @Override
    public void execute(IndexerRequestBuffer indexerRequestBuffer, int numRequests) {
        HashSet<String> searchEngineIds = new HashSet<String>();
        ArrayList<IndexerRequest> completedIndexerRequests = new ArrayList<IndexerRequest>();
        if (_log.isDebugEnabled()) {
            Collection<IndexerRequest> indexerRequests = indexerRequestBuffer.getIndexerRequests();
            _log.debug((Object)("Indexer request buffer size " + indexerRequests.size() + " to execute " + numRequests + " requests"));
        }
        int i = 0;
        for (IndexerRequest indexerRequest : indexerRequestBuffer.getIndexerRequests()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Executing indexer request " + i++ + ": " + indexerRequest));
            }
            this.executeIndexerRequest(searchEngineIds, indexerRequest);
            completedIndexerRequests.add(indexerRequest);
            if (completedIndexerRequests.size() != numRequests) continue;
            break;
        }
        for (IndexerRequest indexerRequest : completedIndexerRequests) {
            indexerRequestBuffer.remove(indexerRequest);
        }
        this.commit(searchEngineIds);
    }
}

