/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal.analysis;

import com.liferay.portal.kernel.search.query.QueryPreProcessConfiguration;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.analysis.FieldQueryBuilderFactory;
import com.liferay.portal.search.internal.analysis.DescriptionFieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.SubstringFieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.TitleFieldQueryBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"description.fields=description", "title.fields=title"}, service={FieldQueryBuilderFactory.class})
public class FieldQueryBuilderFactoryImpl
implements FieldQueryBuilderFactory {
    @Reference
    protected DescriptionFieldQueryBuilder descriptionQueryBuilder;
    @Reference
    protected QueryPreProcessConfiguration queryPreProcessConfiguration;
    @Reference
    protected SubstringFieldQueryBuilder substringQueryBuilder;
    @Reference
    protected TitleFieldQueryBuilder titleQueryBuilder;
    private volatile Collection<String> _descriptionFields = Collections.singleton("description");
    private volatile Collection<String> _titleFields = Collections.singleton("title");

    @Override
    public FieldQueryBuilder getQueryBuilder(String field) {
        if (this.queryPreProcessConfiguration.isSubstringSearchAlways(field)) {
            return this.substringQueryBuilder;
        }
        if (this._descriptionFields.contains(field)) {
            return this.descriptionQueryBuilder;
        }
        if (this._titleFields.contains(field)) {
            return this.titleQueryBuilder;
        }
        return null;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._descriptionFields = this.getFields(properties, "description.fields");
        this._titleFields = this.getFields(properties, "title.fields");
    }

    protected Collection<String> getFields(Map<String, Object> properties, String key) {
        String[] values = StringUtil.split((String)GetterUtil.getString((Object)properties.get(key)), (char)'|');
        return new HashSet<String>(Arrays.asList(values));
    }
}

