/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SortFactory.class})
public class SortFactoryImpl
implements SortFactory {
    private static final Sort[] _DEFAULT_SORTS = new Sort[]{new Sort(null, 0, false), new Sort("modified", 6, true)};
    @Reference
    private IndexerRegistry _indexerRegistry;

    public Sort create(String fieldName, boolean reverse) {
        return new Sort(fieldName, reverse);
    }

    public Sort create(String fieldName, int type, boolean reverse) {
        return new Sort(fieldName, type, reverse);
    }

    public Sort[] getDefaultSorts() {
        return _DEFAULT_SORTS;
    }

    public Sort getSort(Class<?> clazz, int type, String orderByCol, boolean inferSortField, String orderByType) {
        String sortField = orderByCol;
        if (inferSortField) {
            sortField = this.getSortField(orderByCol, type, clazz);
        }
        if (Validator.isNull((String)orderByType)) {
            orderByType = "asc";
        }
        return new Sort(sortField, type, !StringUtil.equalsIgnoreCase((String)orderByType, (String)"asc"));
    }

    public Sort getSort(Class<?> clazz, int type, String orderByCol, String orderByType) {
        return this.getSort(clazz, type, orderByCol, true, orderByType);
    }

    public Sort getSort(Class<?> clazz, String orderByCol, String orderByType) {
        return this.getSort(clazz, 3, orderByCol, orderByType);
    }

    public Sort[] toArray(List<Sort> sorts) {
        if (sorts == null || sorts.isEmpty()) {
            return new Sort[0];
        }
        Sort[] sortsArray = new Sort[sorts.size()];
        for (int i = 0; i < sorts.size(); ++i) {
            sortsArray[i] = sorts.get(i);
        }
        return sortsArray;
    }

    protected String getSortField(String orderByCol, int type, Class<?> clazz) {
        Indexer indexer = this._indexerRegistry.getIndexer(clazz);
        return indexer.getSortField(orderByCol, type);
    }
}

