/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.kernel.exception.NoSuchResourceException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceBlockLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchPermissionChecker.class})
public class SearchPermissionCheckerImpl
implements SearchPermissionChecker {
    private static final Log _log = LogFactoryUtil.getLog(SearchPermissionCheckerImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceBlockLocalService _resourceBlockLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void addPermissionFields(long companyId, Document document) {
        try {
            boolean relatedEntry;
            long groupId = GetterUtil.getLong((String)document.get("groupId"));
            String className = document.get("entryClassName");
            String classPK = document.get("entryClassPK");
            if (Validator.isNull((String)className) && Validator.isNull((String)classPK)) {
                className = document.get("rootEntryClassName");
                classPK = document.get("rootEntryClassPK");
            }
            if (relatedEntry = GetterUtil.getBoolean((String)document.get("relatedEntry"))) {
                long classNameId = GetterUtil.getLong((String)document.get("classNameId"));
                className = this._portal.getClassName(classNameId);
                classPK = document.get("classPK");
            }
            if (Validator.isNull((String)className) || Validator.isNull((String)classPK)) {
                return;
            }
            Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(className);
            if (!indexer.isPermissionAware()) {
                return;
            }
            String viewActionId = document.get("viewActionId");
            if (Validator.isNull((String)viewActionId)) {
                viewActionId = "VIEW";
            }
            this.doAddPermissionFields_6(companyId, groupId, className, classPK, viewActionId, document);
        }
        catch (NoSuchResourceException nsre) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsre, (Throwable)nsre);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public BooleanFilter getPermissionBooleanFilter(long companyId, long[] groupIds, long userId, String className, BooleanFilter booleanFilter, SearchContext searchContext) {
        try {
            booleanFilter = this.doGetPermissionBooleanFilter(companyId, groupIds, userId, className, booleanFilter, searchContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return booleanFilter;
    }

    public void updatePermissionFields(String resourceName, String resourceClassPK) {
        try {
            this.doUpdatePermissionFields(resourceName, resourceClassPK);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void doAddPermissionFields_6(long companyId, long groupId, String className, String classPK, String viewActionId, Document doc) throws Exception {
        List roles = null;
        roles = this._resourceBlockLocalService.isSupported(className) ? this._resourceBlockLocalService.getRoles(className, Long.valueOf(classPK).longValue(), viewActionId) : this._resourcePermissionLocalService.getRoles(companyId, className, 4, classPK, viewActionId);
        if (roles.isEmpty()) {
            return;
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        ArrayList<String> groupRoleIds = new ArrayList<String>();
        for (Role role : roles) {
            if (role.getType() == 3 || role.getType() == 2) {
                groupRoleIds.add(groupId + "-" + role.getRoleId());
                continue;
            }
            roleIds.add(role.getRoleId());
        }
        doc.addKeyword("roleId", roleIds.toArray(new Long[roleIds.size()]));
        doc.addKeyword("groupRoleId", groupRoleIds.toArray(new String[groupRoleIds.size()]));
    }

    protected BooleanFilter doGetPermissionBooleanFilter(long companyId, long[] searchGroupIds, long userId, String className, BooleanFilter booleanFilter, SearchContext searchContext) throws Exception {
        Indexer indexer = this._indexerRegistry.getIndexer(className);
        if (!indexer.isPermissionAware()) {
            return booleanFilter;
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        User user = permissionChecker.getUser();
        if (user == null || user.getUserId() != userId) {
            user = this._userLocalService.fetchUser(userId);
            if (user == null) {
                return booleanFilter;
            }
            permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        }
        if (permissionChecker.getUserBag() == null) {
            return booleanFilter;
        }
        if (permissionChecker.isCompanyAdmin(companyId)) {
            return booleanFilter;
        }
        HashSet<Role> roles = new HashSet<Role>();
        HashMap<Long, List<Role>> usersGroupIdsToRoles = new HashMap<Long, List<Role>>();
        this.populate(companyId, userId, permissionChecker, roles, usersGroupIdsToRoles);
        return this.doGetPermissionFilter_6(companyId, searchGroupIds, userId, permissionChecker, className, booleanFilter, roles, usersGroupIdsToRoles);
    }

    protected BooleanFilter doGetPermissionFilter_6(long companyId, long[] searchGroupIds, long userId, PermissionChecker permissionChecker, String className, BooleanFilter booleanFilter, Set<Role> roles, Map<Long, List<Role>> usersGroupIdsToRoles) throws Exception {
        BooleanFilter permissionBooleanFilter = new BooleanFilter();
        if (userId > 0L) {
            permissionBooleanFilter.addTerm("userId", userId);
        }
        TermsFilter groupsTermsFilter = new TermsFilter("groupId");
        TermsFilter groupRolesTermsFilter = new TermsFilter("groupRoleId");
        TermsFilter rolesTermsFilter = new TermsFilter("roleId");
        ArrayList<Long> roleIds = new ArrayList<Long>(roles.size());
        ArrayList<Long> regularRoleIds = new ArrayList<Long>();
        for (Role role : roles) {
            roleIds.add(role.getRoleId());
            if (role.getType() == 1) {
                regularRoleIds.add(role.getRoleId());
            }
            rolesTermsFilter.addValue(String.valueOf(role.getRoleId()));
        }
        long[] roleIdsArray = ArrayUtil.toLongArray(roleIds);
        if (this._resourcePermissionLocalService.hasResourcePermission(companyId, className, 1, String.valueOf(companyId), roleIdsArray, "VIEW")) {
            return booleanFilter;
        }
        if (this._resourcePermissionLocalService.hasResourcePermission(companyId, className, 3, String.valueOf(0L), ArrayUtil.toLongArray(regularRoleIds), "VIEW")) {
            return booleanFilter;
        }
        for (Map.Entry<Long, List<Role>> entry : usersGroupIdsToRoles.entrySet()) {
            long groupId = entry.getKey();
            List<Role> groupRoles = entry.getValue();
            if (permissionChecker.isGroupAdmin(groupId) || this._resourcePermissionLocalService.hasResourcePermission(companyId, className, 2, String.valueOf(groupId), roleIdsArray, "VIEW") || this._resourcePermissionLocalService.hasResourcePermission(companyId, className, 3, String.valueOf(0L), ListUtil.toLongArray(groupRoles, (Accessor)Role.ROLE_ID_ACCESSOR), "VIEW")) {
                groupsTermsFilter.addValue(String.valueOf(groupId));
            }
            for (Role groupRole : groupRoles) {
                groupRolesTermsFilter.addValue(groupId + "-" + groupRole.getRoleId());
            }
        }
        if (ArrayUtil.isNotEmpty((long[])searchGroupIds)) {
            Set<Long> set = usersGroupIdsToRoles.keySet();
            for (long searchGroupId : searchGroupIds) {
                if (set.contains(searchGroupId) || !this._resourcePermissionLocalService.hasResourcePermission(companyId, className, 2, String.valueOf(searchGroupId), roleIdsArray, "VIEW")) continue;
                groupsTermsFilter.addValue(String.valueOf(searchGroupId));
            }
        }
        if (!groupsTermsFilter.isEmpty()) {
            permissionBooleanFilter.add((Filter)groupsTermsFilter);
        }
        if (!groupRolesTermsFilter.isEmpty()) {
            permissionBooleanFilter.add((Filter)groupRolesTermsFilter);
        }
        if (!rolesTermsFilter.isEmpty()) {
            permissionBooleanFilter.add((Filter)rolesTermsFilter);
        }
        if (!permissionBooleanFilter.hasClauses()) {
            return booleanFilter;
        }
        BooleanFilter booleanFilter2 = new BooleanFilter();
        if (booleanFilter != null && booleanFilter.hasClauses()) {
            booleanFilter2.add((Filter)booleanFilter, BooleanClauseOccur.MUST);
        }
        booleanFilter2.add((Filter)permissionBooleanFilter, BooleanClauseOccur.MUST);
        return booleanFilter2;
    }

    protected void doUpdatePermissionFields(String resourceName, String resourceClassPK) throws Exception {
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(resourceName);
        indexer.reindex(resourceName, GetterUtil.getLong((String)resourceClassPK));
    }

    protected void populate(long companyId, long userId, PermissionChecker permissionChecker, Set<Role> roles, Map<Long, List<Role>> usersGroupIdsToRoles) throws Exception {
        UserBag userBag = permissionChecker.getUserBag();
        if (permissionChecker.isSignedIn()) {
            roles.addAll(userBag.getRoles());
            roles.add(this._roleLocalService.getRole(companyId, "Guest"));
        } else {
            Group guestGroup = this._groupLocalService.getGroup(companyId, "Guest");
            roles.addAll(this._roleLocalService.getUserRelatedRoles(userId, Collections.singletonList(guestGroup)));
        }
        Role organizationUserRole = this._roleLocalService.getRole(companyId, "Organization User");
        Role siteMemberRole = this._roleLocalService.getRole(companyId, "Site Member");
        for (Group group : userBag.getGroups()) {
            long[] roleIds = permissionChecker.getRoleIds(userId, group.getGroupId());
            List groupRoles = this._roleLocalService.getRoles(roleIds);
            roles.addAll(groupRoles);
            Iterator iterator = groupRoles.iterator();
            while (iterator.hasNext()) {
                Role groupRole = (Role)iterator.next();
                if (groupRole.getType() == 3 || groupRole.getType() == 2) continue;
                iterator.remove();
            }
            if (group.isOrganization() && !groupRoles.contains(organizationUserRole)) {
                groupRoles.add(organizationUserRole);
            }
            if (group.isSite() && !groupRoles.contains(siteMemberRole)) {
                groupRoles.add(siteMemberRole);
            }
            usersGroupIdsToRoles.put(group.getGroupId(), groupRoles);
        }
    }
}

