/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;

public class SearchEngineInitializer
implements Runnable {
    private static final Log _log = LogFactoryUtil.getLog(SearchEngineInitializer.class);
    private final long _companyId;
    private boolean _finished;
    private final Set<String> _usedSearchEngineIds;

    public SearchEngineInitializer(long companyId) {
        this._companyId = companyId;
        this._usedSearchEngineIds = new HashSet<String>();
    }

    public Set<String> getUsedSearchEngineIds() {
        return this._usedSearchEngineIds;
    }

    public void halt() {
    }

    public boolean isFinished() {
        return this._finished;
    }

    public void reindex() {
        this.reindex(0);
    }

    public void reindex(int delay) {
        this.doReIndex(delay);
    }

    @Override
    public void run() {
        this.reindex(PropsValues.INDEX_ON_STARTUP_DELAY);
    }

    protected void doReIndex(int delay) {
        block11: {
            if (IndexWriterHelperUtil.isIndexReadOnly()) {
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Reindexing Lucene started");
            }
            if (delay < 0) {
                delay = 0;
            }
            try {
                if (delay > 0) {
                    Thread.sleep(1000L * (long)delay);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                SearchEngineHelperUtil.removeCompany((long)this._companyId);
                SearchEngineHelperUtil.initialize((long)this._companyId);
                HashSet<String> searchEngineIds = new HashSet<String>();
                for (Indexer indexer : IndexerRegistryUtil.getIndexers()) {
                    String searchEngineId = indexer.getSearchEngineId();
                    if (searchEngineIds.add(searchEngineId)) {
                        IndexWriterHelperUtil.deleteEntityDocuments((String)searchEngineId, (long)this._companyId, (String)indexer.getClassName(), (boolean)true);
                    }
                    this.reindex(indexer);
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Reindexing Lucene completed in " + stopWatch.getTime() / 1000L + " seconds"));
                }
            }
            catch (Exception e) {
                _log.error((Object)"Error encountered while reindexing", (Throwable)e);
                if (!_log.isInfoEnabled()) break block11;
                _log.info((Object)"Reindexing Lucene failed");
            }
        }
        this._finished = true;
    }

    protected void reindex(Indexer<?> indexer) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Reindexing with " + indexer.getClass() + " started"));
        }
        indexer.reindex(new String[]{String.valueOf(this._companyId)});
        this._usedSearchEngineIds.add(indexer.getSearchEngineId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Reindexing with " + indexer.getClass() + " completed in " + stopWatch.getTime() / 1000L + " seconds"));
        }
    }
}

