/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineConfigurator;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.queue.QueuingSearchEngine;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.search.configuration.SearchEngineHelperConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.search.configuration.SearchEngineHelperConfiguration"}, immediate=true, service={SearchEngineHelper.class})
public class SearchEngineHelperImpl
implements SearchEngineHelper {
    private static final Log _log = LogFactoryUtil.getLog(SearchEngineHelperImpl.class);
    private final Map<Long, Long> _companyIds = new ConcurrentHashMap<Long, Long>();
    private String _defaultSearchEngineId;
    private final Set<String> _excludedEntryClassNames = new HashSet<String>();
    private int _queueCapacity = 200;
    private final Map<String, QueuingSearchEngine> _queuingSearchEngines = new HashMap<String, QueuingSearchEngine>();
    private final Map<String, SearchEngine> _searchEngines = new ConcurrentHashMap<String, SearchEngine>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueuedSearchEngine() {
        Map<String, QueuingSearchEngine> map = this._queuingSearchEngines;
        synchronized (map) {
            for (QueuingSearchEngine queuingSearchEngine : this._queuingSearchEngines.values()) {
                queuingSearchEngine.flush();
            }
            this._queuingSearchEngines.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueuedSearchEngine(String searchEngineId) {
        QueuingSearchEngine queuingSearchEngine = null;
        Map<String, QueuingSearchEngine> map = this._queuingSearchEngines;
        synchronized (map) {
            queuingSearchEngine = this._queuingSearchEngines.remove(searchEngineId);
        }
        if (queuingSearchEngine != null) {
            queuingSearchEngine.flush();
        }
    }

    public Collection<Long> getCompanyIds() {
        return this._companyIds.keySet();
    }

    public String getDefaultSearchEngineId() {
        if (this._defaultSearchEngineId == null) {
            return "SYSTEM_ENGINE";
        }
        return this._defaultSearchEngineId;
    }

    public String[] getEntryClassNames() {
        HashSet<String> assetEntryClassNames = new HashSet<String>();
        for (Indexer indexer : IndexerRegistryUtil.getIndexers()) {
            for (String className : indexer.getSearchClassNames()) {
                if (this._excludedEntryClassNames.contains(className)) continue;
                assetEntryClassNames.add(className);
            }
        }
        return assetEntryClassNames.toArray(new String[assetEntryClassNames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchEngine getSearchEngine(String searchEngineId) {
        PortalRuntimePermission.checkSearchEngine((String)searchEngineId);
        SearchEngine searchEngine = this._searchEngines.get(searchEngineId);
        if (searchEngine != null) {
            return searchEngine;
        }
        Map<String, QueuingSearchEngine> map = this._queuingSearchEngines;
        synchronized (map) {
            searchEngine = (SearchEngine)this._queuingSearchEngines.get(searchEngineId);
            if (searchEngine == null) {
                QueuingSearchEngine queuingSearchEngine = new QueuingSearchEngine(this._queueCapacity);
                this._queuingSearchEngines.put(searchEngineId, queuingSearchEngine);
                searchEngine = queuingSearchEngine;
            }
            return searchEngine;
        }
    }

    public String getSearchEngineId(Collection<Document> documents) {
        if (!documents.isEmpty()) {
            Iterator<Document> iterator = documents.iterator();
            Document document = iterator.next();
            return this.getSearchEngineId(document);
        }
        return this.getDefaultSearchEngineId();
    }

    public String getSearchEngineId(Document document) {
        String entryClassName = document.get("entryClassName");
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)entryClassName);
        String searchEngineId = indexer.getSearchEngineId();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search engine ID " + searchEngineId + " is associated with " + ClassUtil.getClassName((Object)indexer)));
        }
        return searchEngineId;
    }

    public Set<String> getSearchEngineIds() {
        return this._searchEngines.keySet();
    }

    public Collection<SearchEngine> getSearchEngines() {
        return Collections.unmodifiableCollection(this._searchEngines.values());
    }

    public SearchEngine getSearchEngineSilent(String searchEngineId) {
        return this._searchEngines.get(searchEngineId);
    }

    public String getSearchReaderDestinationName(String searchEngineId) {
        return "liferay/search_reader".concat("/").concat(searchEngineId);
    }

    public String getSearchWriterDestinationName(String searchEngineId) {
        return "liferay/search_writer".concat("/").concat(searchEngineId);
    }

    public synchronized void initialize(long companyId) {
        if (this._companyIds.containsKey(companyId)) {
            return;
        }
        this._companyIds.put(companyId, companyId);
        for (SearchEngine searchEngine : this._searchEngines.values()) {
            searchEngine.initialize(companyId);
        }
    }

    public synchronized void removeCompany(long companyId) {
        if (!this._companyIds.containsKey(companyId)) {
            return;
        }
        for (SearchEngine searchEngine : this._searchEngines.values()) {
            searchEngine.removeCompany(companyId);
        }
        this._companyIds.remove(companyId);
    }

    public SearchEngine removeSearchEngine(String searchEngineId) {
        PortalRuntimePermission.checkSearchEngine((String)searchEngineId);
        return this._searchEngines.remove(searchEngineId);
    }

    public void setDefaultSearchEngineId(String defaultSearchEngineId) {
        this._defaultSearchEngineId = defaultSearchEngineId;
    }

    public void setQueueCapacity(int queueCapacity) {
        this._queueCapacity = queueCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSearchEngine(String searchEngineId, SearchEngine searchEngine) {
        PortalRuntimePermission.checkSearchEngine((String)searchEngineId);
        this._searchEngines.put(searchEngineId, searchEngine);
        for (Long companyId : this._companyIds.keySet()) {
            searchEngine.initialize(companyId.longValue());
        }
        Map<String, QueuingSearchEngine> map = this._queuingSearchEngines;
        synchronized (map) {
            block7: {
                QueuingSearchEngine queuingSearchEngine = this._queuingSearchEngines.get(searchEngineId);
                if (queuingSearchEngine != null) {
                    try {
                        queuingSearchEngine.invokeQueued(searchEngine.getIndexWriter());
                    }
                    catch (Exception e) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Object)("Unable to execute pending write events for engine: " + searchEngineId), (Throwable)e);
                    }
                }
            }
        }
    }

    @Activate
    @Modified
    protected synchronized void activate(Map<String, Object> properties) {
        SearchEngineHelperConfiguration searchEngineHelperConfiguration = (SearchEngineHelperConfiguration)ConfigurableUtil.createConfigurable(SearchEngineHelperConfiguration.class, properties);
        this._excludedEntryClassNames.addAll(Arrays.asList(searchEngineHelperConfiguration.excludedEntryClassNames()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="removeSearchEngineConfigurator")
    protected void addSearchEngineConfigurator(SearchEngineConfigurator searchEngineConfigurator) {
        searchEngineConfigurator.afterPropertiesSet();
    }

    protected void removeSearchEngineConfigurator(SearchEngineConfigurator searchEngineConfigurator) {
        searchEngineConfigurator.destroy();
    }
}

