/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.dummy.DummyIndexer;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.search.buffer.IndexerRequestBuffer;
import com.liferay.portal.search.buffer.IndexerRequestBufferOverflowHandler;
import com.liferay.portal.search.configuration.IndexerRegistryConfiguration;
import com.liferay.portal.search.index.IndexStatusManager;
import com.liferay.portal.search.internal.buffer.BufferedIndexerInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ClassUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.portal.search.configuration.IndexerRegistryConfiguration"}, immediate=true, service={IndexerRegistry.class})
public class IndexerRegistryImpl
implements IndexerRegistry {
    private static final Log _log = LogFactoryUtil.getLog(IndexerRegistryImpl.class);
    private final Map<String, BufferedIndexerInvocationHandler> _bufferedInvocationHandlers = new ConcurrentHashMap<String, BufferedIndexerInvocationHandler>();
    @Reference(target="(mode=DEFAULT)")
    private IndexerRequestBufferOverflowHandler _defaultIndexerRequestBufferOverflowHandler;
    private final Indexer<?> _dummyIndexer = new DummyIndexer();
    private volatile IndexerRegistryConfiguration _indexerRegistryConfiguration;
    private volatile IndexerRequestBufferOverflowHandler _indexerRequestBufferOverflowHandler;
    private final Map<String, Indexer<? extends Object>> _indexers = new ConcurrentHashMap<String, Indexer<? extends Object>>();
    @Reference
    private IndexStatusManager _indexStatusManager;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    private final Map<String, Indexer<? extends Object>> _proxiedIndexers = new ConcurrentHashMap<String, Indexer<? extends Object>>();

    public <T> Indexer<T> getIndexer(Class<T> clazz) {
        return this.getIndexer(clazz.getName());
    }

    public <T> Indexer<T> getIndexer(String className) {
        Indexer<? extends Object> indexer = this._indexers.get(className);
        return this.proxyIndexer(indexer);
    }

    public Set<Indexer<?>> getIndexers() {
        return new HashSet(this._indexers.values());
    }

    public <T> Indexer<T> nullSafeGetIndexer(Class<T> clazz) {
        return this.nullSafeGetIndexer(clazz.getName());
    }

    public <T> Indexer<T> nullSafeGetIndexer(String className) {
        Indexer<T> indexer = this.getIndexer(className);
        if (indexer != null) {
            return indexer;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("No indexer found for " + className));
        }
        return this._dummyIndexer;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="unregister")
    public void register(Indexer<?> indexer) {
        Class<?> clazz = indexer.getClass();
        this._indexers.put(clazz.getName(), indexer);
        this._indexers.put(indexer.getClassName(), indexer);
    }

    public void unregister(Indexer<?> indexer) {
        Class<?> clazz = indexer.getClass();
        this.unregister(clazz.getName());
        this.unregister(indexer.getClassName());
    }

    public void unregister(String className) {
        this._bufferedInvocationHandlers.remove(className);
        this._indexers.remove(className);
        this._proxiedIndexers.remove(className);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._indexerRegistryConfiguration = (IndexerRegistryConfiguration)ConfigurableUtil.createConfigurable(IndexerRegistryConfiguration.class, properties);
        for (BufferedIndexerInvocationHandler bufferedIndexerInvocationHandler : this._bufferedInvocationHandlers.values()) {
            bufferedIndexerInvocationHandler.setIndexerRegistryConfiguration(this._indexerRegistryConfiguration);
        }
    }

    protected <T> Indexer<T> proxyIndexer(Indexer<T> indexer) {
        if (indexer == null) {
            return null;
        }
        IndexerRequestBuffer indexerRequestBuffer = IndexerRequestBuffer.get();
        if (indexerRequestBuffer == null || !this._indexerRegistryConfiguration.buffered()) {
            return indexer;
        }
        Indexer proxiedIndexer = this._proxiedIndexers.get(indexer.getClassName());
        if (proxiedIndexer == null) {
            List interfaces = ClassUtils.getAllInterfaces(indexer.getClass());
            BufferedIndexerInvocationHandler bufferedIndexerInvocationHandler = new BufferedIndexerInvocationHandler(indexer, this._indexStatusManager, this._indexerRegistryConfiguration, this._persistedModelLocalServiceRegistry);
            if (this._indexerRequestBufferOverflowHandler == null) {
                bufferedIndexerInvocationHandler.setIndexerRequestBufferOverflowHandler(this._defaultIndexerRequestBufferOverflowHandler);
            } else {
                bufferedIndexerInvocationHandler.setIndexerRequestBufferOverflowHandler(this._indexerRequestBufferOverflowHandler);
            }
            this._bufferedInvocationHandlers.put(indexer.getClassName(), bufferedIndexerInvocationHandler);
            proxiedIndexer = (Indexer)ProxyUtil.newProxyInstance((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (Class[])interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)bufferedIndexerInvocationHandler);
            this._proxiedIndexers.put(indexer.getClassName(), (Indexer<? extends Object>)proxiedIndexer);
        }
        return proxiedIndexer;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setIndexerRequestBufferOverflowHandler(IndexerRequestBufferOverflowHandler indexerRequestBufferOverflowHandler) {
        this._indexerRequestBufferOverflowHandler = indexerRequestBufferOverflowHandler;
        for (BufferedIndexerInvocationHandler bufferedIndexerInvocationHandler : this._bufferedInvocationHandlers.values()) {
            bufferedIndexerInvocationHandler.setIndexerRequestBufferOverflowHandler(this._indexerRequestBufferOverflowHandler);
        }
    }

    protected void unsetIndexerRequestBufferOverflowHandler(IndexerRequestBufferOverflowHandler indexerRequestBufferOverflowHandler) {
        this._indexerRequestBufferOverflowHandler = null;
        for (BufferedIndexerInvocationHandler bufferedIndexerInvocationHandler : this._bufferedInvocationHandlers.values()) {
            bufferedIndexerInvocationHandler.setIndexerRequestBufferOverflowHandler(this._defaultIndexerRequestBufferOverflowHandler);
        }
    }
}

