/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.osgi.util.StringPlus;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.IndexerRegistry;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true)
public class IndexerPostProcessorRegistry {
    private static final Log _log = LogFactoryUtil.getLog(IndexerPostProcessorRegistry.class);
    @Reference
    private IndexerRegistry _indexerRegistry;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(indexer.class.name=*)", unbind="removeIndexerPostProcessor")
    protected void addIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor, Map<String, Object> properties) {
        List indexerClassNames = StringPlus.asList((Object)properties.get("indexer.class.name"));
        for (String indexerClassName : indexerClassNames) {
            Indexer indexer = this._indexerRegistry.getIndexer(indexerClassName);
            if (indexer == null) {
                _log.error((Object)("No indexer exists for " + indexerClassName));
                continue;
            }
            indexer.registerIndexerPostProcessor(indexerPostProcessor);
        }
    }

    protected void removeIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor, Map<String, Object> properties) {
        List indexerClassNames = StringPlus.asList((Object)properties.get("indexer.class.name"));
        for (String indexerClassName : indexerClassNames) {
            Indexer indexer = this._indexerRegistry.getIndexer(indexerClassName);
            if (indexer == null) {
                _log.error((Object)("No indexer exists for " + indexerClassName));
                continue;
            }
            indexer.unregisterIndexerPostProcessor(indexerPostProcessor);
        }
    }
}

