/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.internal.instance.lifecycle.IndexOnStartupPortalInstanceLifecycleListener;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true)
public class IndexOnStartupIndexerServiceCustomizer
implements ServiceTrackerCustomizer<Indexer, Indexer> {
    private static final Log _log = LogFactoryUtil.getLog(IndexOnStartupIndexerServiceCustomizer.class);
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    private BundleContext _bundleContext;
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private Props _props;
    private final Map<String, ServiceRegistration<PortalInstanceLifecycleListener>> _serviceRegistrations = new HashMap<String, ServiceRegistration<PortalInstanceLifecycleListener>>();
    private ServiceTracker<Indexer, Indexer> _serviceTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Indexer addingService(ServiceReference<Indexer> serviceReference) {
        Indexer indexer = (Indexer)this._bundleContext.getService(serviceReference);
        boolean indexerIndexOnStartup = GetterUtil.getBoolean((Object)serviceReference.getProperty("index.on.startup"), (boolean)true);
        String className = indexer.getClassName();
        if (!indexerIndexOnStartup || Validator.isNull((String)className) || this.isBaseSearcher(indexer.getClass())) {
            return indexer;
        }
        Map<String, ServiceRegistration<PortalInstanceLifecycleListener>> map = this._serviceRegistrations;
        synchronized (map) {
            if (this._serviceRegistrations.containsKey(className)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Skip duplicate service registration for " + className));
                }
                return indexer;
            }
            IndexOnStartupPortalInstanceLifecycleListener portalInstanceLifecycleListener = new IndexOnStartupPortalInstanceLifecycleListener(this._clusterMasterExecutor, this._indexWriterHelper, this._props, className);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(PortalInstanceLifecycleListener.class, (Object)portalInstanceLifecycleListener, (Dictionary)new HashMapDictionary());
            this._serviceRegistrations.put(className, (ServiceRegistration<PortalInstanceLifecycleListener>)serviceRegistration);
        }
        return indexer;
    }

    public void modifiedService(ServiceReference<Indexer> serviceReference, Indexer indexer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<Indexer> serviceReference, Indexer indexer) {
        Map<String, ServiceRegistration<PortalInstanceLifecycleListener>> map = this._serviceRegistrations;
        synchronized (map) {
            ServiceRegistration<PortalInstanceLifecycleListener> serviceRegistration = this._serviceRegistrations.remove(indexer.getClassName());
            if (serviceRegistration != null) {
                serviceRegistration.unregister();
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTracker = new ServiceTracker(bundleContext, Indexer.class, (ServiceTrackerCustomizer)this);
        this._serviceTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        HashSet<String> removedIndexerClassNames = new HashSet<String>();
        Map<String, ServiceRegistration<PortalInstanceLifecycleListener>> map = this._serviceRegistrations;
        synchronized (map) {
            for (Map.Entry<String, ServiceRegistration<PortalInstanceLifecycleListener>> entry : this._serviceRegistrations.entrySet()) {
                ServiceRegistration<PortalInstanceLifecycleListener> serviceRegistration = entry.getValue();
                serviceRegistration.unregister();
                removedIndexerClassNames.add(entry.getKey());
            }
            for (String removedIndexerClassName : removedIndexerClassNames) {
                this._serviceRegistrations.remove(removedIndexerClassName);
            }
        }
        this._bundleContext = null;
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
        }
    }

    protected boolean isBaseSearcher(Class indexerClass) {
        while (indexerClass != null && !Object.class.equals((Object)indexerClass)) {
            if (indexerClass.equals(BaseSearcher.class)) {
                return true;
            }
            indexerClass = indexerClass.getSuperclass();
        }
        return false;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(target="(search.engine.id=SYSTEM_ENGINE)", unbind="-")
    protected void setSearchEngine(SearchEngine searchEngine) {
    }
}

