/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.internal;

import com.liferay.portal.kernel.search.IndexAdminHelper;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.SearchException;
import java.util.Collection;
import java.util.Iterator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexAdminHelper.class})
public class IndexAdminHelperImpl
implements IndexAdminHelper {
    @Reference
    private SearchEngineHelper _searchEngineHelper;

    public synchronized void backup(long companyId, String backupName) throws SearchException {
        Collection searchEngines = this._searchEngineHelper.getSearchEngines();
        for (SearchEngine searchEngine : searchEngines) {
            searchEngine.backup(companyId, backupName);
        }
    }

    public synchronized String backup(long companyId, String searchEngineId, String backupName) throws SearchException {
        SearchEngine searchEngine = this._searchEngineHelper.getSearchEngine(searchEngineId);
        return searchEngine.backup(companyId, backupName);
    }

    public synchronized void backup(String backupName) throws SearchException {
        Collection searchEngines = this._searchEngineHelper.getSearchEngines();
        for (SearchEngine searchEngine : searchEngines) {
            Iterator iterator = this._searchEngineHelper.getCompanyIds().iterator();
            while (iterator.hasNext()) {
                long companyId = (Long)iterator.next();
                searchEngine.backup(companyId, backupName);
            }
        }
    }

    public synchronized void removeBackup(long companyId, String backupName) throws SearchException {
        Collection searchEngines = this._searchEngineHelper.getSearchEngines();
        for (SearchEngine searchEngine : searchEngines) {
            searchEngine.removeBackup(companyId, backupName);
        }
    }

    public synchronized void removeBackup(String backupName) throws SearchException {
        Collection searchEngines = this._searchEngineHelper.getSearchEngines();
        for (SearchEngine searchEngine : searchEngines) {
            Iterator iterator = this._searchEngineHelper.getCompanyIds().iterator();
            while (iterator.hasNext()) {
                long companyId = (Long)iterator.next();
                searchEngine.removeBackup(companyId, backupName);
            }
        }
    }

    public synchronized void restore(long companyId, String backupName) throws SearchException {
        Collection searchEngines = this._searchEngineHelper.getSearchEngines();
        for (SearchEngine searchEngine : searchEngines) {
            searchEngine.restore(companyId, backupName);
        }
    }

    public synchronized void restore(String backupName) throws SearchException {
        Collection searchEngines = this._searchEngineHelper.getSearchEngines();
        for (SearchEngine searchEngine : searchEngines) {
            Iterator iterator = this._searchEngineHelper.getCompanyIds().iterator();
            while (iterator.hasNext()) {
                long companyId = (Long)iterator.next();
                searchEngine.restore(companyId, backupName);
            }
        }
    }
}

