/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
AUI.add('liferay-search-modified-facet-configuration', function (A) {
  var ModifiedFacetConfiguration = function ModifiedFacetConfiguration(form) {
    var instance = this;
    instance.form = form;
    instance.form.on('submit', A.bind(instance._onSubmit, instance));
  };

  A.mix(ModifiedFacetConfiguration.prototype, {
    _onSubmit: function _onSubmit(event) {
      var instance = this;
      event.preventDefault();
      var ranges = [];
      var rangeFormRows = A.all('.range-form-row').filter(function (item) {
        return !item.get('hidden');
      });
      rangeFormRows.each(function (item) {
        var label = item.one('.label-input').val();
        var range = item.one('.range-input').val();
        ranges.push({
          label: label,
          range: range
        });
      });
      instance.form.one('.ranges-input').val(JSON.stringify(ranges));
      submitForm(instance.form);
    }
  });
  Liferay.namespace('Search').ModifiedFacetConfiguration = ModifiedFacetConfiguration;
}, '', {
  requires: ['aui-node']
});
//# sourceMappingURL=modified_facet_configuration.js.map