/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.stats;

import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.search.internal.stats.StatsRequestBuilderFactoryImpl;
import com.liferay.portal.search.internal.stats.StatsResponseBuilderImpl;
import com.liferay.portal.search.stats.StatsRequest;
import com.liferay.portal.search.stats.StatsRequestBuilder;
import com.liferay.portal.search.stats.StatsRequestBuilderFactory;
import com.liferay.portal.search.stats.StatsResponse;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseStatisticsTestCase
extends BaseIndexingTestCase {
    protected static final String STAT_FIELD = "priority";
    protected static final String STAT_SORTABLE_FIELD = "priority_Number_sortable";
    private final StatsRequestBuilderFactory _statsRequestBuilderFactory = new StatsRequestBuilderFactoryImpl();

    @Test
    public void testStats() throws Exception {
        this.addDocuments(31);
        final String field = STAT_SORTABLE_FIELD;
        Stats stats = new Stats(){
            {
                this.setCount(true);
                this.setField(field);
                this.setMax(true);
                this.setMean(true);
                this.setMin(true);
                this.setSum(true);
                this.setSumOfSquares(true);
            }
        };
        StatsResults expectedStatsResults = new StatsResults(field){
            {
                this.setCount(31L);
                this.setMax(31.0);
                this.setMean(16.0);
                this.setMin(1.0);
                this.setSum(496.0);
                this.setSumOfSquares(10416.0);
            }
        };
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> searchContext.addStats(stats));
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> {
                Map statsResultsMap = hits.getStatsResults();
                Assert.assertNotNull((Object)statsResultsMap);
                StatsResults statsResults = (StatsResults)statsResultsMap.get(field);
                Assert.assertNotNull((Object)statsResults);
                Assert.assertEquals((Object)BaseStatisticsTestCase.toString(expectedStatsResults), (Object)BaseStatisticsTestCase.toString(statsResults));
            });
        });
    }

    @Test
    public void testStatsAgainstSearchCount() throws Exception {
        this.addDocuments(31);
        final String field = STAT_SORTABLE_FIELD;
        Stats stats = new Stats(){
            {
                this.setCount(true);
                this.setField(field);
            }
        };
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> searchContext.addStats(stats));
            indexingTestHelper.searchCount();
            indexingTestHelper.verify(hits -> Assert.assertNull((Object)hits));
            indexingTestHelper.verifyResponse(searchResponse -> {
                Map map = searchResponse.getStatsResponseMap();
                Assert.assertTrue((boolean)map.isEmpty());
            });
        });
    }

    @Test
    public void testStatsRequest() throws Exception {
        this.addDocuments(31);
        String field = STAT_SORTABLE_FIELD;
        StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder();
        StatsRequest statsRequest = statsRequestBuilder.cardinality(true).count(true).field(field).max(true).mean(true).min(true).missing(true).sum(true).sumOfSquares(true).build();
        StatsResponseBuilderImpl statsResponseBuilder = new StatsResponseBuilderImpl();
        StatsResponse expectedStatsResponse = statsResponseBuilder.cardinality(31L).count(31L).field(field).max(31.0).mean(16.0).min(1.0).sum(496.0).sumOfSquares(10416.0).build();
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequest -> searchRequest.statsRequests(new StatsRequest[]{statsRequest}));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> {
                Map map = searchResponse.getStatsResponseMap();
                Assert.assertNotNull((Object)map);
                StatsResponse statsResponse = (StatsResponse)map.get(field);
                Assert.assertNotNull((Object)statsResponse);
                Assert.assertEquals((Object)BaseStatisticsTestCase.toString(expectedStatsResponse), (Object)BaseStatisticsTestCase.toString(statsResponse));
            });
        });
    }

    @Test
    public void testStatsRequestAgainstSearchCount() throws Exception {
        this.addDocuments(31);
        String field = STAT_SORTABLE_FIELD;
        StatsRequestBuilder statsRequestBuilder = this._statsRequestBuilderFactory.getStatsRequestBuilder();
        StatsRequest statsRequest = statsRequestBuilder.cardinality(true).field(field).build();
        StatsResponseBuilderImpl statsResponseBuilder = new StatsResponseBuilderImpl();
        StatsResponse expectedStatsResponse = statsResponseBuilder.cardinality(31L).field(field).build();
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.statsRequests(new StatsRequest[]{statsRequest}));
            indexingTestHelper.searchCount();
            indexingTestHelper.verifyResponse(searchResponse -> {
                Map map = searchResponse.getStatsResponseMap();
                Assert.assertNotNull((Object)map);
                StatsResponse statsResponse = (StatsResponse)map.get(field);
                Assert.assertNotNull((Object)statsResponse);
                Assert.assertEquals((Object)BaseStatisticsTestCase.toString(expectedStatsResponse), (Object)BaseStatisticsTestCase.toString(statsResponse));
            });
        });
    }

    protected static String toString(StatsResponse statsResponse) {
        return String.valueOf(LinkedHashMapBuilder.put((Object)"cardinality", (Object)statsResponse.getCardinality()).put((Object)"count", (Object)statsResponse.getCount()).put((Object)"field", (Object)statsResponse.getField()).put((Object)"max", (Object)statsResponse.getMax()).put((Object)"mean", (Object)statsResponse.getMean()).put((Object)"min", (Object)statsResponse.getMin()).put((Object)"missing", (Object)statsResponse.getMissing()).put((Object)"standardDeviation", (Object)statsResponse.getStandardDeviation()).put((Object)"sum", (Object)statsResponse.getSum()).put((Object)"sumOfSquares", (Object)statsResponse.getSumOfSquares()).build());
    }

    protected static String toString(StatsResults statsResults) {
        return String.valueOf(LinkedHashMapBuilder.put((Object)"count", (Object)statsResults.getCount()).put((Object)"field", (Object)statsResults.getField()).put((Object)"max", (Object)statsResults.getMax()).put((Object)"mean", (Object)statsResults.getMean()).put((Object)"min", (Object)statsResults.getMin()).put((Object)"missing", (Object)statsResults.getMissing()).put((Object)"standardDeviation", (Object)statsResults.getStandardDeviation()).put((Object)"sum", (Object)statsResults.getSum()).put((Object)"sumOfSquares", (Object)statsResults.getSumOfSquares()).build());
    }

    protected void addDocuments(int count) throws Exception {
        String field = STAT_FIELD;
        for (int i = 1; i <= count; ++i) {
            this.addDocument(DocumentCreationHelpers.singleNumberSortable(field, i));
        }
    }
}

