/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.sort;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelper;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import org.junit.Test;

public abstract class BaseMultiLanguageSortTestCase
extends BaseIndexingTestCase {
    @Test
    public void testEnglishCaseSensitive() {
        this.testLocaleSort(LocaleUtil.US, new String[]{"a", "E", "c", "O", "u", "A"}, "[a, A, c, E, O, u]");
    }

    @Test
    public void testFrance() {
        this.testLocaleSort(LocaleUtil.FRANCE, new String[]{"e", "a", "d", "\u00e7"}, "[a, \u00e7, d, e]");
    }

    @Test
    public void testGerman() {
        this.testLocaleSort(LocaleUtil.GERMANY, new String[]{"a", "x", "\u00e4", "\u00f6", "o", "u", "\u017a"}, "[a, \u00e4, o, \u00f6, u, x, \u017a]");
    }

    @Test
    public void testJapanHiragana() {
        this.testLocaleSort(LocaleUtil.JAPAN, new String[]{"\u3048", "\u3046", "\u3044", "\u3042", "\u304a"}, "[\u3042, \u3044, \u3046, \u3048, \u304a]");
    }

    @Test
    public void testJapanKatakana() {
        this.testLocaleSort(LocaleUtil.JAPAN, new String[]{"\u30aa", "\u30a4", "\u30a2", "\u30a8", "\u30a6"}, "[\u30a2, \u30a4, \u30a6, \u30a8, \u30aa]");
    }

    @Test
    public void testPolish() {
        this.testLocaleSort(new Locale("pl", "PL"), new String[]{"f", "\u0107", "\u017a", "d", "\u0142", "\u015b", "b"}, "[b, \u0107, d, f, \u0142, \u015b, \u017a]");
    }

    @Test
    public void testPortuguese() {
        this.testLocaleSort(LocaleUtil.BRAZIL, new String[]{"a", "e", "c", "u", "\u00e0", "\u00e1", "\u00e9", "\u00e3", "o", "\u00f5", "\u00fc", "\u00e7"}, "[a, \u00e1, \u00e0, \u00e3, c, \u00e7, e, \u00e9, o, \u00f5, u, \u00fc]");
    }

    @Test
    public void testSpanish() {
        this.testLocaleSort(LocaleUtil.SPAIN, new String[]{"a", "\u00e9", "d", "c", "cu", "ch", "ll", "\u00f1a", "nu", "p", "e", "\u00e1"}, "[a, \u00e1, c, ch, cu, d, e, \u00e9, ll, nu, \u00f1a, p]");
    }

    protected void addDocuments(Function<Double, DocumentCreationHelper> function, double ... values) {
        for (double value : values) {
            this.addDocument(function.apply(value));
        }
    }

    protected void assertOrder(Sort[] sorts, String fieldName, String expected, Locale locale) {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> {
                searchContext.setLocale(locale);
                searchContext.setSorts(sorts);
            });
            indexingTestHelper.search();
            indexingTestHelper.verify(hits -> DocumentsAssert.assertValues(indexingTestHelper.getRequestString(), hits.getDocs(), fieldName, expected));
        });
    }

    protected void testLocaleSort(Locale locale, String[] values, String expected) {
        String fieldName = "title";
        String fieldNameSortable = StringBundler.concat((String[])new String[]{fieldName, "_", LocaleUtil.toLanguageId((Locale)locale), "_", "sortable"});
        this.addDocuments((String value) -> DocumentCreationHelpers.twoKeywords(fieldName, value, fieldNameSortable, value), Arrays.asList(values));
        this.assertOrder(new Sort[]{new Sort(fieldNameSortable, 3, false)}, fieldName, expected, locale);
    }
}

