/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.rescore;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.Field;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.StringQuery;
import com.liferay.portal.search.rescore.Rescore;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseRescoreTestCase
extends BaseIndexingTestCase {
    private static final String _TITLE = "title";

    @Test
    public void testRescore() {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_TITLE, value), Arrays.asList("alpha zeta", "alpha alpha", "alpha beta beta"));
        StringQuery query = this.queries.string(_TITLE.concat(":alpha"));
        this.assertSearch(Arrays.asList("alpha alpha", "alpha zeta", "alpha beta beta"), _TITLE, (Query)query, null, null);
        this.assertSearch(Arrays.asList("alpha beta beta", "alpha alpha", "alpha zeta"), _TITLE, (Query)query, null, Arrays.asList(this.buildRescore(_TITLE, "beta")));
    }

    @Test
    public void testRescoreQuery() {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_TITLE, value), Arrays.asList("alpha alpha", "alpha gamma gamma", "alpha beta beta"));
        StringQuery query = this.queries.string(_TITLE.concat(":alpha"));
        this.assertSearch(Arrays.asList("alpha alpha", "alpha gamma gamma", "alpha beta beta"), _TITLE, (Query)query, null, null);
        this.assertSearch(Arrays.asList("alpha beta beta", "alpha alpha", "alpha gamma gamma"), _TITLE, (Query)query, (Query)this.queries.match(_TITLE, (Object)"beta"), null);
    }

    @Test
    public void testRescores() {
        this.addDocuments((String value) -> DocumentCreationHelpers.singleText(_TITLE, value), Arrays.asList("alpha alpha", "alpha gamma gamma", "alpha beta beta beta"));
        StringQuery query = this.queries.string(_TITLE.concat(":alpha"));
        this.assertSearch(Arrays.asList("alpha alpha", "alpha gamma gamma", "alpha beta beta beta"), _TITLE, (Query)query, null, null);
        this.assertSearch(Arrays.asList("alpha beta beta beta", "alpha gamma gamma", "alpha alpha"), _TITLE, (Query)query, null, Arrays.asList(this.buildRescore(_TITLE, "beta"), this.buildRescore(_TITLE, "gamma")));
    }

    protected void assertSearch(List<String> expectedValues, String fieldName, Query query, Query rescoreQuery, List<Rescore> rescores) {
        this.assertSearch(indexingTestHelper -> {
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames(new String[]{String.valueOf(this.getCompanyId())});
            searchSearchRequest.setQuery(query);
            searchSearchRequest.setRescoreQuery(rescoreQuery);
            searchSearchRequest.setRescores(rescores);
            searchSearchRequest.setSize(Integer.valueOf(30));
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            List searchHitsList = searchHits.getSearchHits();
            Stream stream = searchHitsList.stream();
            List actualValues = stream.map(searchHit -> {
                Document document = searchHit.getDocument();
                Map fields = document.getFields();
                Field field = (Field)fields.get(fieldName);
                return (String)field.getValue();
            }).collect(Collectors.toList());
            Assert.assertEquals((Object)expectedValues.toString(), (Object)actualValues.toString());
        });
    }

    protected Rescore buildRescore(String fieldName, String value) {
        return this.rescoreBuilderFactory.builder((Query)this.queries.match(fieldName, (Object)value)).windowSize(Integer.valueOf(100)).build();
    }
}

