/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.pagination;

import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class BasePaginationTestCase
extends BaseIndexingTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final int _TOTAL_DOCUMENTS = 20;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        for (int i = 0; i < 20; ++i) {
            this.addDocument(DocumentCreationHelpers.singleText("test-field", StringUtil.toLowerCase((String)this.testName.getMethodName())));
        }
    }

    @Test
    public void testBadEnd() throws Exception {
        this._assertBadRange(-1, -2, "Invalid end -2");
    }

    @Test
    public void testBadStart() throws Exception {
        this._assertBadRange(-2, -1, "Invalid start -2");
    }

    @Test
    public void testFirst() throws Exception {
        this._assertPagination(0, 1, 1);
    }

    @Test
    public void testFirstUnbounded() throws Exception {
        this._assertPagination(-1, 1, 1);
    }

    @Test
    public void testLast() throws Exception {
        this._assertPagination(19, 20, 1);
    }

    @Test
    public void testLastUnbounded() throws Exception {
        this._assertPagination(19, -1, 1);
    }

    @Test
    public void testMiddle() throws Exception {
        this._assertPagination(5, 8, 3);
    }

    @Test
    public void testMiddleOne() throws Exception {
        this._assertPagination(5, 6, 1);
    }

    @Test
    public void testMiddleUntilPastLast() throws Exception {
        this._assertPagination(16, 24, 4);
    }

    @Test
    public void testNextToLast() throws Exception {
        this._assertPagination(18, 19, 1);
    }

    @Test
    public void testNone() throws Exception {
        this._assertPagination(0, 0, 0);
    }

    @Test
    public void testPastLast() throws Exception {
        this._assertPagination(20, 21, 1);
    }

    @Test
    public void testUnbounded() throws Exception {
        this._assertPagination(-1, -1, 20);
    }

    @Test
    public void testWayPastLast() throws Exception {
        this._assertPagination(25, 26, 1);
    }

    private void _assertBadRange(int start, int end, String message) {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(message);
        this.search(this._createSearchContext(start, end));
    }

    private void _assertPagination(int start, int end, int expectedSize) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.define(searchContext -> {
                searchContext.setEnd(end);
                searchContext.setStart(start);
            });
            indexingTestHelper.setQuery(this.getDefaultQuery());
            Assert.assertEquals((long)20L, (long)indexingTestHelper.searchCount());
            indexingTestHelper.search();
            indexingTestHelper.assertResultCount(expectedSize);
        });
    }

    private SearchContext _createSearchContext(int start, int end) {
        SearchContext searchContext = this.createSearchContext();
        searchContext.setEnd(end);
        searchContext.setStart(start);
        return searchContext;
    }
}

