/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.analysis.FieldQueryBuilder;
import com.liferay.portal.search.internal.analysis.SimpleKeywordTokenizer;
import com.liferay.portal.search.internal.analysis.TitleFieldQueryBuilder;
import com.liferay.portal.search.test.util.mappings.BaseFieldQueryBuilderTestCase;
import org.junit.Test;

public abstract class BaseMaxExpansionsTestCase
extends BaseFieldQueryBuilderTestCase {
    protected static final int MAX_EXPANSIONS = 5;
    private static final int _TOTAL_DOCUMENTS = 10;

    @Test
    public void testPrefixWithDashNumberSuffix() throws Exception {
        this.addDocuments("Prefix-#");
        this.assertSearch("Prefi", 10);
        this.assertSearchCount("Prefi", 10);
    }

    @Test
    public void testPrefixWithDotNumberSuffix() throws Exception {
        this.addDocuments("Prefix.#");
        this.assertSearch("Prefi", 10);
        this.assertSearchCount("Prefi", 10);
    }

    @Test
    public void testPrefixWithNoSuffix() throws Exception {
        this.addDocuments("Prefix");
        this.assertSearch("Prefi", 10);
        this.assertSearchCount("Prefi", 10);
    }

    @Test
    public void testPrefixWithNumberSpaceNumberSuffix() throws Exception {
        this.addDocuments("Prefix# #");
        this.assertSearch("Prefi", 5);
        this.assertSearchCount("Prefi", 5);
    }

    @Test
    public void testPrefixWithNumberSuffix() throws Exception {
        this.addDocuments("Prefix#");
        this.assertSearch("Prefi", 5);
        this.assertSearchCount("Prefi", 5);
    }

    @Test
    public void testPrefixWithSpaceNumberSuffix() throws Exception {
        this.addDocuments("Prefix #");
        this.assertSearch("Prefi", 10);
        this.assertSearchCount("Prefi", 10);
    }

    @Test
    public void testPrefixWithUnderscoreNumberSuffix() throws Exception {
        this.addDocuments("Prefix_#");
        this.assertSearch("Prefi", 5);
        this.assertSearchCount("Prefi", 5);
    }

    protected void addDocuments(String pattern) throws Exception {
        for (int i = 1; i <= 10; ++i) {
            this.addDocument(StringUtil.replace((String)pattern, (char)'#', (String)String.valueOf(i)));
        }
    }

    @Override
    protected FieldQueryBuilder createFieldQueryBuilder() {
        return new TitleFieldQueryBuilder(){
            {
                this.keywordTokenizer = new SimpleKeywordTokenizer();
                this.activate(HashMapBuilder.put((Object)"maxExpansions", (Object)5).build());
            }
        };
    }

    @Override
    protected String getField() {
        return "title";
    }
}

