/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.mappings;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.test.util.document.BaseDocumentTestCase;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseDocumentMappingTestCase
extends BaseDocumentTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.addDocuments((String screenName) -> document -> this.populate(document, (String)screenName), this.getScreenNamesStream());
    }

    @Test
    public void testFirstNamesSearchResults() throws Exception {
        Stream<String> stream = this.getScreenNamesStream();
        stream.forEach(screenName -> {
            String firstName = screenName.replaceFirst("user", "");
            this.assertMappings(firstName);
        });
    }

    @Test
    public void testLastNameSearchResults() throws Exception {
        this.assertMappings("Smith");
    }

    protected void assertMappings(Document document) {
        String screenName = document.get("screenName");
        Assert.assertEquals((double)Double.valueOf(document.get("sd")), (double)((Double)doubles.get(screenName)), (double)0.0);
        Assert.assertEquals((float)Long.valueOf(document.get("sl")).longValue(), (float)((Long)longs.get(screenName)).longValue(), (float)0.0f);
        Assert.assertEquals((float)Float.valueOf(document.get("sf")).floatValue(), (float)((Float)floats.get(screenName)).floatValue(), (float)0.0f);
        Assert.assertEquals((float)Integer.valueOf(document.get("si")).intValue(), (float)((Integer)integers.get(screenName)).intValue(), (float)0.0f);
        Assert.assertArrayEquals((Object[])this.getDoubleArray(document), (Object[])((Object[])doubleArrays.get(screenName)));
        Assert.assertArrayEquals((Object[])this.getLongArray(document), (Object[])((Object[])longArrays.get(screenName)));
        Assert.assertArrayEquals((Object[])this.getFloatArray(document), (Object[])((Object[])floatArrays.get(screenName)));
        Assert.assertArrayEquals((Object[])this.getIntegerArray(document), (Object[])((Object[])integerArrays.get(screenName)));
    }

    protected void assertMappings(final String keywords) {
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)new SearchSearchRequest(){
                {
                    this.setIndexNames(new String[]{BaseDocumentMappingTestCase.this.getIndexName()});
                    this.setQuery(BaseDocumentMappingTestCase.getQuery(keywords));
                    this.setSelectedFieldNames(new String[]{"*"});
                }
            });
            Hits hits = searchSearchResponse.getHits();
            Document[] documents = hits.getDocs();
            Assert.assertNotEquals((long)0L, (long)documents.length);
            for (Document document : documents) {
                this.assertMappings(document);
            }
        });
    }

    protected Double[] getDoubleArray(Document document) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (String value : document.getValues("md")) {
            list.add(Double.valueOf(value));
        }
        return list.toArray(new Double[0]);
    }

    protected Float[] getFloatArray(Document document) {
        ArrayList<Float> list = new ArrayList<Float>();
        for (String value : document.getValues("mf")) {
            list.add(Float.valueOf(value));
        }
        return list.toArray(new Float[0]);
    }

    protected abstract String getIndexName();

    protected Integer[] getIntegerArray(Document document) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String value : document.getValues("mi")) {
            list.add(Integer.valueOf(value));
        }
        return list.toArray(new Integer[0]);
    }

    protected Long[] getLongArray(Document document) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (String value : document.getValues("ml")) {
            list.add(Long.valueOf(value));
        }
        return list.toArray(new Long[0]);
    }
}

