/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.indexing;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.test.util.PropsTestUtil;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import org.mockito.Mockito;

public class DocumentFixture {
    protected Props props;
    private FastDateFormatFactory _fastDateFormatFactory;
    private Props _props;

    public static Document newDocument(long companyId, long groupId, String entryClassName) {
        DocumentImpl documentImpl = new DocumentImpl();
        documentImpl.addKeyword("companyId", companyId);
        documentImpl.addKeyword("groupId", groupId);
        long entryClassPK = RandomTestUtil.randomLong();
        documentImpl.addUID(entryClassName, entryClassPK);
        DocumentHelper documentHelper = new DocumentHelper((Document)documentImpl);
        documentHelper.setEntryKey(entryClassName, entryClassPK);
        return documentImpl;
    }

    public void setUp() {
        this.setUpFastDateFormatFactoryUtil();
        this.setUpPropsUtil();
    }

    public void tearDown() {
        this.tearDownFastDateFormatFactoryUtil();
        this.tearDownPropsUtil();
    }

    protected void setUpFastDateFormatFactoryUtil() {
        this._fastDateFormatFactory = FastDateFormatFactoryUtil.getFastDateFormatFactory();
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        FastDateFormatFactory fastDateFormatFactory = (FastDateFormatFactory)Mockito.mock(FastDateFormatFactory.class);
        Mockito.when((Object)fastDateFormatFactory.getSimpleDateFormat("yyyyMMddHHmmss")).thenReturn((Object)new SimpleDateFormat("yyyyMMddHHmmss"));
        fastDateFormatFactoryUtil.setFastDateFormatFactory(fastDateFormatFactory);
    }

    protected void setUpPropsUtil() {
        this.props = PropsTestUtil.setProps((Map)HashMapBuilder.put((Object)"index.date.format.pattern", (Object)"yyyyMMddHHmmss").put((Object)"index.search.collated.spell.check.result.enabled", (Object)"true").put((Object)"index.search.collated.spell.check.result.scores.threshold", (Object)"50").put((Object)"index.search.highlight.fragment.size", (Object)"80").put((Object)"index.search.highlight.require.field.match", (Object)"true").put((Object)"index.search.highlight.snippet.size", (Object)"3").put((Object)"index.search.query.indexing.enabled", (Object)"true").put((Object)"index.search.query.indexing.threshold", (Object)"50").put((Object)"index.search.query.suggestion.enabled", (Object)"true").put((Object)"index.search.query.suggestion.max", (Object)"yyyyMMddHHmmss").put((Object)"index.search.query.suggestion.scores.threshold", (Object)"0").put((Object)"index.search.scoring.enabled", (Object)"true").put((Object)"index.sortable.text.fields.truncated.length", (Object)"255").put((Object)"configuration.override.", (Object)new Properties()).build());
    }

    protected void tearDownFastDateFormatFactoryUtil() {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory(this._fastDateFormatFactory);
        this._fastDateFormatFactory = null;
    }

    protected void tearDownPropsUtil() {
        PropsUtil.setProps((Props)this._props);
        this._props = null;
        this.props = null;
    }
}

