/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.filter;

import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.Arrays;
import org.junit.Test;

public abstract class BaseTermsFilterTestCase
extends BaseIndexingTestCase {
    private static final String _FIELD = "folderId";

    @Test
    public void testBasicSearch() throws Exception {
        this.index("One");
        this.index("Two");
        this.index("Three");
        this.assertTermsFilter(new String[]{"Two", "Three"});
    }

    @Test
    public void testLuceneSpecialCharacters() throws Exception {
        this.index("One\\+-!():^[]\"{}~*?|&/Two");
        this.index("Three");
        this.assertTermsFilter(new String[]{"One\\+-!():^[]\"{}~*?|&/Two", "Three"});
    }

    @Test
    public void testSolrSpecialCharacters() throws Exception {
        this.index("One\\+-!():^[]\"{}~*?|&/; Two");
        this.index("Three");
        this.assertTermsFilter(new String[]{"One\\+-!():^[]\"{}~*?|&/; Two", "Three"});
    }

    @Test
    public void testSpaces() throws Exception {
        this.index("One Two");
        this.index("Three");
        this.assertTermsFilter(new String[]{"One Two", "Three"});
    }

    protected void assertTermsFilter(final String[] values) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.setFilter((Filter)new TermsFilter(_FIELD){
                {
                    super(x0);
                    this.addValues(values);
                }
            });
            indexingTestHelper.search();
            indexingTestHelper.assertValues(_FIELD, Arrays.asList(values));
        });
    }

    protected void index(String value) throws Exception {
        this.addDocument(DocumentCreationHelpers.singleKeyword(_FIELD, value));
    }
}

