/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet.user;

import com.liferay.portal.json.JSONFactoryImpl;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.search.facet.user.UserFacetSearchContributor;
import com.liferay.portal.search.internal.facet.user.UserFacetFactoryImpl;
import com.liferay.portal.search.internal.facet.user.UserFacetSearchContributorImpl;
import com.liferay.portal.search.test.util.FacetsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseUserFacetSearchContributorTestCase
extends BaseIndexingTestCase {
    protected static final String USE = "use";
    private UserFacetSearchContributor _userFacetSearchContributor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setUpJSONFactoryUtil();
        this._userFacetSearchContributor = new UserFacetSearchContributorImpl();
        ReflectionTestUtil.setFieldValue((Object)this._userFacetSearchContributor, (String)"_userFacetFactory", (Object)new UserFacetFactoryImpl());
    }

    @Test
    public void testFrequencies() throws Exception {
        this.index("alpha");
        this.index("beta");
        this.index("beta");
        this.index("charlie");
        this.index("charlie");
        this.index("charlie");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> this._userFacetSearchContributor.contribute(searchRequestBuilder, userFacetBuilder -> userFacetBuilder.aggregationName(USE)));
            indexingTestHelper.search();
            indexingTestHelper.verifyResponse(searchResponse -> searchResponse.withFacetContext(facetContext -> FacetsAssert.assertFrequencies(searchResponse.getRequestString(), facetContext.getFacet(USE), "[charlie=3, beta=2, alpha=1]")));
        });
    }

    protected void index(String user) throws Exception {
        this.addDocument(DocumentCreationHelpers.singleKeyword("userName", user));
    }

    protected void setUpJSONFactoryUtil() {
        JSONFactoryUtil jsonFactoryUtil = new JSONFactoryUtil();
        jsonFactoryUtil.setJSONFactory((JSONFactory)new JSONFactoryImpl());
    }
}

