/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.facet;

import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.search.facet.tag.AssetTagNamesFacetFactory;
import com.liferay.portal.search.internal.facet.tag.AssetTagNamesFacetFactoryImpl;
import com.liferay.portal.search.test.util.facet.BaseFacetTestCase;
import com.liferay.portal.search.test.util.indexing.QueryContributors;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;

public abstract class BaseAssetTagNamesFacetTestCase
extends BaseFacetTestCase {
    protected AssetTagNamesFacetFactory assetTagNamesFacetFactory = new AssetTagNamesFacetFactoryImpl();

    @Test
    public void testCaseInsensitiveSearchCaseSensitiveGrouping() throws Exception {
        this.addDocument("tag");
        this.addDocument("tAg");
        this.addDocument("TAG");
        this.addDocument(RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0]));
        this.assertSearchFacet(helper -> {
            com.liferay.portal.search.facet.Facet facet = helper.addFacet(this::createFacet);
            helper.setQueryContributor(QueryContributors.mustMatch(this.getField(), "tag"));
            helper.search();
            helper.assertFrequencies((Facet)facet, Arrays.asList("TAG=1", "tAg=1", "tag=1"));
        });
    }

    @Test
    public void testKeysWithSpaces() throws Exception {
        this.addDocument("Green-Blue Tag");
        this.addDocument("Green-Blue Tag", "Red Tag");
        this.addDocument("Tag");
        this.assertSearchFacet(helper -> {
            com.liferay.portal.search.facet.Facet facet = helper.addFacet(this::createFacet);
            helper.search();
            helper.assertFrequencies((Facet)facet, Arrays.asList("Green-Blue Tag=2", "Red Tag=1", "Tag=1"));
        });
    }

    @Test
    public void testSelectionWithSpaces() throws Exception {
        this.addDocument("spaceless");
        this.addDocument("with spaces");
        List<String> frequencies = Arrays.asList("spaceless=1", "with spaces=1");
        this.assertSearchFacet(helper -> {
            com.liferay.portal.search.facet.Facet facet = helper.addFacet(this::createFacet);
            facet.select(new String[]{"spaceless", "with spaces"});
            helper.search();
            helper.assertFrequencies((Facet)facet, frequencies);
            helper.assertValues(this.getField(), Arrays.asList("spaceless", "with spaces"));
        });
        this.assertSearchFacet(helper -> {
            com.liferay.portal.search.facet.Facet facet = helper.addFacet(this::createFacet);
            facet.select(new String[]{"spaceless"});
            helper.search();
            helper.assertFrequencies((Facet)facet, frequencies);
            helper.assertValues(this.getField(), Arrays.asList("spaceless"));
        });
        this.assertSearchFacet(helper -> {
            com.liferay.portal.search.facet.Facet facet = helper.addFacet(this::createFacet);
            facet.select(new String[]{"with spaces"});
            helper.search();
            helper.assertFrequencies((Facet)facet, frequencies);
            helper.assertValues(this.getField(), Arrays.asList("with spaces"));
        });
    }

    protected com.liferay.portal.search.facet.Facet createFacet(SearchContext searchContext) {
        com.liferay.portal.search.facet.Facet facet = this.assetTagNamesFacetFactory.newInstance(searchContext);
        this.initFacet((Facet)facet);
        return facet;
    }

    @Override
    protected String getField() {
        return "assetTagNames";
    }
}

