/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.document;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.BeforeClass;

public abstract class BaseDocumentTestCase
extends BaseIndexingTestCase {
    protected static final String FIELD_DOUBLE = "sd";
    protected static final String FIELD_DOUBLE_ARRAY = "md";
    protected static final String FIELD_FLOAT = "sf";
    protected static final String FIELD_FLOAT_ARRAY = "mf";
    protected static final String FIELD_INTEGER = "si";
    protected static final String FIELD_INTEGER_ARRAY = "mi";
    protected static final String FIELD_LONG = "sl";
    protected static final String FIELD_LONG_ARRAY = "ml";
    protected static final String[] SCREEN_NAMES = new String[]{"firstuser", "seconduser", "thirduser", "fourthuser", "fifthuser", "sixthuser"};
    protected static final Map<String, Double[]> doubleArrays = new HashMap<String, Double[]>();
    protected static final Map<String, Double> doubles = new HashMap<String, Double>();
    protected static final Map<String, Float[]> floatArrays = new HashMap<String, Float[]>();
    protected static final Map<String, Float> floats = new HashMap<String, Float>();
    protected static final Map<String, Integer[]> integerArrays = new HashMap<String, Integer[]>();
    protected static final Map<String, Integer> integers = new HashMap<String, Integer>();
    protected static final Map<String, Long[]> longArrays = new HashMap<String, Long[]>();
    protected static final Map<String, Long> longs = new HashMap<String, Long>();

    @BeforeClass
    public static void setUpClassTestData() throws Exception {
        BaseDocumentTestCase.populateNumberArrays();
        BaseDocumentTestCase.populateNumbers();
    }

    protected static Query getQuery(String keywords) {
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        booleanQueryImpl.add((Query)new MatchQuery("firstName", keywords), BooleanClauseOccur.SHOULD);
        booleanQueryImpl.add((Query)new MatchQuery("lastName", keywords), BooleanClauseOccur.SHOULD);
        return booleanQueryImpl;
    }

    protected static void populateNumberArrays() {
        BaseDocumentTestCase.populateNumberArrays(SCREEN_NAMES[0], new Double[]{1.0E-11, 2.0E-11, 3.0E-11}, new Float[]{Float.valueOf(8.0E-5f), Float.valueOf(8.0E-5f), Float.valueOf(8.0E-5f)}, new Integer[]{1, 2, 3}, new Long[]{-3L, -2L, -1L});
        BaseDocumentTestCase.populateNumberArrays(SCREEN_NAMES[1], new Double[]{1.0E-11, 2.0E-11, 5.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(8.0E-5f), Float.valueOf(7.0E-5f)}, new Integer[]{1, 3, 4}, new Long[]{-3L, -2L, -2L});
        BaseDocumentTestCase.populateNumberArrays(SCREEN_NAMES[2], new Double[]{1.0E-11, 3.0E-11, 2.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(8.0E-5f), Float.valueOf(9.0E-5f)}, new Integer[]{2, 1, 1}, new Long[]{-3L, -3L, -1L});
        BaseDocumentTestCase.populateNumberArrays(SCREEN_NAMES[3], new Double[]{1.0E-11, 2.0E-11, 4.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(9.0E-5f), Float.valueOf(7.0E-5f)}, new Integer[]{1, 2, 4}, new Long[]{-3L, -3L, -2L});
        BaseDocumentTestCase.populateNumberArrays(SCREEN_NAMES[4], new Double[]{1.0E-11, 3.0E-11, 1.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(9.0E-5f), Float.valueOf(8.0E-5f)}, new Integer[]{1, 4, 4}, new Long[]{-4L, -2L, -1L});
        BaseDocumentTestCase.populateNumberArrays(SCREEN_NAMES[5], new Double[]{2.0E-11, 1.0E-11, 1.0E-11}, new Float[]{Float.valueOf(9.0E-5f), Float.valueOf(9.0E-5f), Float.valueOf(9.0E-5f)}, new Integer[]{2, 1, 2}, new Long[]{-4L, -2L, -2L});
    }

    protected static void populateNumberArrays(String screenName, Double[] doubleArray, Float[] floatArray, Integer[] integerArray, Long[] longArray) {
        doubleArrays.put(screenName, doubleArray);
        floatArrays.put(screenName, floatArray);
        integerArrays.put(screenName, integerArray);
        longArrays.put(screenName, longArray);
    }

    protected static void populateNumbers() {
        int maxInt = Integer.MAX_VALUE;
        long minLong = Long.MIN_VALUE;
        BaseDocumentTestCase.populateNumbers(SCREEN_NAMES[0], 1.0E-11, Float.valueOf(8.0E-5f), maxInt, minLong);
        BaseDocumentTestCase.populateNumbers(SCREEN_NAMES[1], 3.0E-11, Float.valueOf(7.0E-5f), maxInt - 1, minLong + 1L);
        BaseDocumentTestCase.populateNumbers(SCREEN_NAMES[2], 5.0E-11, Float.valueOf(6.0E-5f), maxInt - 2, minLong + 2L);
        BaseDocumentTestCase.populateNumbers(SCREEN_NAMES[3], 2.0E-11, Float.valueOf(5.0E-5f), maxInt - 3, minLong + 3L);
        BaseDocumentTestCase.populateNumbers(SCREEN_NAMES[4], 4.0E-11, Float.valueOf(4.0E-5f), maxInt - 4, minLong + 4L);
        BaseDocumentTestCase.populateNumbers(SCREEN_NAMES[5], 6.0E-11, Float.valueOf(3.0E-5f), maxInt - 5, minLong + 5L);
    }

    protected static void populateNumbers(String screenName, Double numberDouble, Float floatNumber, Integer numberInteger, Long longNumber) {
        doubles.put(screenName, numberDouble);
        floats.put(screenName, floatNumber);
        integers.put(screenName, numberInteger);
        longs.put(screenName, longNumber);
    }

    protected Stream<String> getScreenNamesStream() {
        List<String> screenNames = Arrays.asList(SCREEN_NAMES);
        return screenNames.stream();
    }

    protected void populate(Document document, String screenName) {
        document.addKeyword("firstName", screenName.replaceFirst("user", ""));
        document.addKeyword("lastName", "Smith");
        document.addText("screenName", screenName);
        document.addNumber(FIELD_DOUBLE, doubles.get(screenName));
        document.addNumber(FIELD_FLOAT, floats.get(screenName));
        document.addNumber(FIELD_INTEGER, integers.get(screenName));
        document.addNumber(FIELD_LONG, longs.get(screenName));
        document.addNumber(FIELD_DOUBLE_ARRAY, doubleArrays.get(screenName));
        document.addNumber(FIELD_FLOAT_ARRAY, floatArrays.get(screenName));
        document.addNumber(FIELD_INTEGER_ARRAY, integerArrays.get(screenName));
        document.addNumber(FIELD_LONG_ARRAY, longArrays.get(screenName));
    }

    protected void populate(Document document, String field, String screenName) {
        document.addKeyword("firstName", screenName.replaceFirst("user", ""));
        document.addKeyword("lastName", "Smith");
        document.addText("screenName", screenName);
        if (Objects.equals(field, FIELD_DOUBLE)) {
            document.addNumber(field, doubles.get(screenName));
        } else if (Objects.equals(field, FIELD_FLOAT)) {
            document.addNumber(field, floats.get(screenName));
        } else if (Objects.equals(field, FIELD_INTEGER)) {
            document.addNumber(field, integers.get(screenName));
        } else if (Objects.equals(field, FIELD_LONG)) {
            document.addNumber(field, longs.get(screenName));
        } else if (Objects.equals(field, FIELD_DOUBLE_ARRAY)) {
            document.addNumber(field, doubleArrays.get(screenName));
        } else if (Objects.equals(field, FIELD_FLOAT_ARRAY)) {
            document.addNumber(field, floatArrays.get(screenName));
        } else if (Objects.equals(field, FIELD_INTEGER_ARRAY)) {
            document.addNumber(field, integerArrays.get(screenName));
        } else if (Objects.equals(field, FIELD_LONG_ARRAY)) {
            document.addNumber(field, longArrays.get(screenName));
        }
    }
}

