/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.count;

import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.test.util.document.BaseDocumentTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseDocumentCountTestCase
extends BaseDocumentTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.addDocuments((String screenName) -> document -> this.populate(document, (String)screenName), this.getScreenNamesStream());
    }

    @Test
    public void testAllWordsInAllDocuments() throws Exception {
        this.assertCount("sixth fifth fourth third second first", 6);
    }

    @Test
    public void testOneWordInAllDocuments() throws Exception {
        this.assertCount("Smith", 6);
    }

    @Test
    public void testOneWordPerDocument() throws Exception {
        this.assertCount("first", 1);
        this.assertCount("second", 1);
        this.assertCount("third", 1);
        this.assertCount("fourth", 1);
        this.assertCount("fifth", 1);
        this.assertCount("sixth", 1);
    }

    protected void assertCount(final String keywords, int expectedCount) throws Exception {
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)new SearchSearchRequest(){
                {
                    this.setIndexNames(new String[]{BaseDocumentCountTestCase.this.getIndexName()});
                    this.setQuery(BaseDocumentCountTestCase.getQuery(keywords));
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)expectedCount, (long)searchHits.getTotalHits());
        });
    }

    protected abstract String getIndexName();
}

