/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.background.task;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.search.background.task.ReindexStatusMessageSender;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.internal.SearchEngineHelperImpl;
import com.liferay.portal.search.internal.background.task.ReindexSingleIndexerBackgroundTaskExecutor;
import com.liferay.portal.search.test.util.search.engine.SearchEngineFixture;
import com.liferay.portal.util.PropsImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class BaseReindexSingleIndexerBackgroundTaskExecutorTestCase {
    private final BackgroundTask _backgroundTask = (BackgroundTask)Mockito.mock(BackgroundTask.class);
    private long _companyId;
    private final Indexer<Object> _indexer = (Indexer)Mockito.mock(Indexer.class);
    private final IndexerRegistry _indexerRegistry = (IndexerRegistry)Mockito.mock(IndexerRegistry.class);
    private final IndexWriterHelper _indexWriterHelper = (IndexWriterHelper)Mockito.mock(IndexWriterHelper.class);
    private final ReindexStatusMessageSender _reindexStatusMessageSender = (ReindexStatusMessageSender)Mockito.mock(ReindexStatusMessageSender.class);
    private SearchEngineFixture _searchEngineFixture;
    private SearchEngineHelper _searchEngineHelper;
    private final ServiceTrackerList<Indexer<?>> _systemIndexers = (ServiceTrackerList)Mockito.mock(ServiceTrackerList.class);

    @BeforeClass
    public static void setUpClass() {
        PropsUtil.setProps((Props)new PropsImpl());
    }

    @Before
    public void setUp() throws Exception {
        long companyId = RandomTestUtil.randomLong();
        this.setUpBackgroundTask(companyId);
        this.setUpIndexerRegistry();
        SearchEngineFixture searchEngineFixture = this.getSearchEngineFixture();
        searchEngineFixture.setUp();
        SearchEngineHelperImpl searchEngineHelper = new SearchEngineHelperImpl();
        ReflectionTestUtil.setFieldValue((Object)searchEngineHelper, (String)"_searchEngine", (Object)searchEngineFixture.getSearchEngine());
        this._companyId = companyId;
        this._searchEngineFixture = searchEngineFixture;
        this._searchEngineHelper = searchEngineHelper;
    }

    @After
    public void tearDown() throws Exception {
        if (this._searchEngineFixture != null) {
            this._searchEngineFixture.tearDown();
        }
    }

    @Test
    public void testFieldMappings() throws Exception {
        ReindexSingleIndexerBackgroundTaskExecutor reindexSingleIndexerBackgroundTaskExecutor = this.getReindexSingleIndexerBackgroundTaskExecutor();
        reindexSingleIndexerBackgroundTaskExecutor.execute(this._backgroundTask);
        this.assertFieldType("entryClassName", "keyword");
    }

    protected abstract void assertFieldType(String var1, String var2) throws Exception;

    protected String getIndexName() {
        IndexNameBuilder indexNameBuilder = this._searchEngineFixture.getIndexNameBuilder();
        return indexNameBuilder.getIndexName(this._companyId);
    }

    protected ReindexSingleIndexerBackgroundTaskExecutor getReindexSingleIndexerBackgroundTaskExecutor() {
        return new ReindexSingleIndexerBackgroundTaskExecutor(){
            {
                this.indexerRegistry = BaseReindexSingleIndexerBackgroundTaskExecutorTestCase.this._indexerRegistry;
                indexWriterHelper = BaseReindexSingleIndexerBackgroundTaskExecutorTestCase.this._indexWriterHelper;
                this.reindexStatusMessageSender = BaseReindexSingleIndexerBackgroundTaskExecutorTestCase.this._reindexStatusMessageSender;
                this.searchEngineHelper = BaseReindexSingleIndexerBackgroundTaskExecutorTestCase.this._searchEngineHelper;
                this.systemIndexers = BaseReindexSingleIndexerBackgroundTaskExecutorTestCase.this._systemIndexers;
            }
        };
    }

    protected abstract SearchEngineFixture getSearchEngineFixture();

    protected void setUpBackgroundTask(long companyId) {
        Mockito.when((Object)this._backgroundTask.getTaskContextMap()).thenReturn((Object)HashMapBuilder.put((Object)"className", (Object)RandomTestUtil.randomString((RandomizerBumper[])new RandomizerBumper[0])).put((Object)"companyIds", (Object)new long[]{companyId}).build());
    }

    protected void setUpIndexerRegistry() {
        Mockito.when((Object)this._indexerRegistry.getIndexer(Mockito.anyString())).thenReturn(this._indexer);
    }
}

