/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.BucketAggregationResult;
import com.liferay.portal.search.aggregation.bucket.FiltersAggregation;
import com.liferay.portal.search.aggregation.bucket.FiltersAggregationResult;
import com.liferay.portal.search.aggregation.metrics.SumAggregation;
import com.liferay.portal.search.aggregation.metrics.SumAggregationResult;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseFiltersAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testFilter() throws Exception {
        this.index("SomeUser1", 1);
        this.index("SomeUser1", 2);
        this.index("SomeUser1", 3);
        this.index("SomeUser2", 4);
        this.index("SomeUser2", 5);
        this.index("SomeUser2", 6);
        this.index("SomeUser2", 7);
        FiltersAggregation filtersAggregation = this.aggregations.filters("filter", "userName");
        filtersAggregation.addKeyedQuery("SomeUser1", (Query)this.queries.term("userName", (Object)"SomeUser1"));
        filtersAggregation.addKeyedQuery("SomeUser2", (Query)this.queries.term("userName", (Object)"SomeUser2"));
        SumAggregation sumAggregation = this.aggregations.sum("sum", "priority");
        filtersAggregation.addChildAggregation((Aggregation)sumAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)filtersAggregation));
            indexingTestHelper.search();
            FiltersAggregationResult filtersAggregationResult = (FiltersAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)filtersAggregation);
            this.assertBucket("SomeUser1", 3, 6, (BucketAggregationResult)filtersAggregationResult, sumAggregation, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper);
            this.assertBucket("SomeUser2", 4, 22, (BucketAggregationResult)filtersAggregationResult, sumAggregation, (BaseIndexingTestCase.IndexingTestHelper)indexingTestHelper);
            Collection buckets = filtersAggregationResult.getBuckets();
            Assert.assertEquals((String)"Number of buckets", (long)2L, (long)buckets.size());
        });
    }

    protected void assertBucket(String userName, int size, int sum, BucketAggregationResult bucketAggregationResult, SumAggregation sumAggregation, BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) {
        Bucket bucket = bucketAggregationResult.getBucket(userName);
        Assert.assertEquals((String)"bucket size", (long)size, (long)bucket.getDocCount());
        SumAggregationResult sumAggregationResult = (SumAggregationResult)indexingTestHelper.getChildAggregationResult(bucket, (Aggregation)sumAggregation);
        Assert.assertEquals((String)("sum of priorities of " + userName), (double)sum, (double)sumAggregationResult.getValue(), (double)0.0);
    }

    protected void index(String userName, int priority) {
        this.addDocument((Document document) -> {
            document.addKeyword("userName", userName);
            document.addNumber("priority", priority);
        });
    }
}

