/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.layout.test.util.LayoutTestUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portletmvc4spring.test.mock.web.portlet.MockPortletResponse;
import com.liferay.portletmvc4spring.test.mock.web.portlet.MockRenderRequest;
import java.util.Collections;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class SummaryFixture<T> {
    private final Class<T> _clazz;
    private final Locale _defaultLocale;
    private final Group _group;
    private final Indexer<T> _indexer;
    private final User _user;

    public SummaryFixture(Class<T> clazz, Group group, Locale defaultLocale, User user) {
        this._clazz = clazz;
        this._group = group;
        this._defaultLocale = defaultLocale;
        this._user = user;
        this._indexer = IndexerRegistryUtil.getIndexer(clazz);
    }

    public void assertSummary(String title, String content, Document document) throws Exception {
        this.assertSummary(title, content, this._defaultLocale, document);
    }

    public void assertSummary(String title, String content, Locale locale, Document document) throws Exception {
        Assert.assertEquals((Object)this._clazz.getName(), (Object)document.get("entryClassName"));
        Summary summary = this.getSummary(document, locale);
        Assert.assertEquals((Object)content, (Object)summary.getContent());
        Assert.assertEquals((Object)title, (Object)summary.getTitle());
    }

    public Summary getSummary(Document document, Locale locale) throws Exception {
        return this._indexer.getSummary(document, document.get("snippet"), this.createPortletRequest(locale), this.createPortletResponse());
    }

    protected HttpServletRequest createHttpServletRequest(PortletRequest portletRequest, Locale locale) {
        MockHttpServletRequest mockHttpServletRequest = new MockHttpServletRequest();
        mockHttpServletRequest.setAttribute("javax.portlet.request", (Object)portletRequest);
        mockHttpServletRequest.setPreferredLocales(Collections.singletonList(locale));
        return mockHttpServletRequest;
    }

    protected HttpServletResponse createHttpServletResponse() {
        return new MockHttpServletResponse();
    }

    protected PortletRequest createPortletRequest(Locale locale) throws Exception {
        MockRenderRequest mockRenderRequest = new MockRenderRequest();
        HttpServletRequest httpServletRequest = this.createHttpServletRequest((PortletRequest)mockRenderRequest, locale);
        HttpServletResponse httpServletResponse = this.createHttpServletResponse();
        ThemeDisplay themeDisplay = this.createThemeDisplay(httpServletRequest, httpServletResponse, locale);
        mockRenderRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        mockRenderRequest.addPreferredLocale(locale);
        httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplay);
        return mockRenderRequest;
    }

    protected PortletResponse createPortletResponse() {
        return new MockPortletResponse();
    }

    protected ThemeDisplay createThemeDisplay(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) throws Exception {
        ThemeDisplay themeDisplay = new ThemeDisplay();
        themeDisplay.setCompany(CompanyLocalServiceUtil.getCompany((long)this._group.getCompanyId()));
        themeDisplay.setLayout(LayoutTestUtil.addTypePortletLayout((Group)this._group));
        LayoutSet layoutSet = this._group.getPublicLayoutSet();
        themeDisplay.setLayoutSet(layoutSet);
        themeDisplay.setLocale(locale);
        themeDisplay.setLookAndFeel(ThemeLocalServiceUtil.getTheme((long)this._group.getCompanyId(), (String)layoutSet.getThemeId()), null);
        themeDisplay.setRealUser(this._user);
        themeDisplay.setRequest(httpServletRequest);
        themeDisplay.setResponse(httpServletResponse);
        themeDisplay.setTimeZone(TimeZoneUtil.getDefault());
        themeDisplay.setUser(this._user);
        return themeDisplay;
    }
}

