/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util;

import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ClassNameWrapper;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.result.SearchResultTranslator;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalServiceWrapper;
import com.liferay.portal.kernel.test.util.PropsTestUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.search.test.util.SearchTestUtil;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.BundleContext;

public abstract class BaseSearchResultUtilTestCase {
    protected BundleContext bundleContext = SystemBundleUtil.getBundleContext();
    protected ClassNameLocalService classNameLocalService;
    protected SearchResultTranslator searchResultTranslator;

    @Before
    public void setUp() throws Exception {
        this.setUpClassNameLocalService();
        this.setUpFastDateFormatFactoryUtil();
        this.setUpPropsUtil();
        this.setUpSearchResultTranslator();
    }

    protected void assertEmptyCommentRelatedSearchResults(SearchResult searchResult) {
        List commentRelatedSearchResults = searchResult.getCommentRelatedSearchResults();
        Assert.assertTrue((String)commentRelatedSearchResults.toString(), (boolean)commentRelatedSearchResults.isEmpty());
    }

    protected void assertEmptyFileEntryRelatedSearchResults(SearchResult searchResult) {
        List fileEntryRelatedSearchResults = searchResult.getFileEntryRelatedSearchResults();
        Assert.assertTrue((String)fileEntryRelatedSearchResults.toString(), (boolean)fileEntryRelatedSearchResults.isEmpty());
    }

    protected void assertEmptyVersions(SearchResult searchResult) {
        List versions = searchResult.getVersions();
        Assert.assertTrue((String)versions.toString(), (boolean)versions.isEmpty());
    }

    protected SearchResult assertOneSearchResult(Document document) {
        List<SearchResult> searchResults = SearchTestUtil.getSearchResults(this.searchResultTranslator, document);
        Assert.assertEquals((String)searchResults.toString(), (long)1L, (long)searchResults.size());
        return searchResults.get(0);
    }

    protected abstract SearchResultTranslator createSearchResultTranslator();

    protected void setUpClassNameLocalService() {
        this.classNameLocalService = new ClassNameLocalServiceWrapper(){

            public ClassName getClassName(long classNameId) {
                if (classNameId == SearchTestUtil.ATTACHMENT_OWNER_CLASS_NAME_ID) {
                    return new ClassNameWrapper(null){

                        public String getClassName() {
                            return SearchTestUtil.ATTACHMENT_OWNER_CLASS_NAME;
                        }
                    };
                }
                return null;
            }
        };
    }

    protected void setUpFastDateFormatFactoryUtil() {
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory((FastDateFormatFactory)ProxyFactory.newDummyInstance(FastDateFormatFactory.class));
    }

    protected void setUpPropsUtil() {
        PropsTestUtil.setProps(Collections.emptyMap());
    }

    protected void setUpSearchResultTranslator() {
        this.searchResultTranslator = this.createSearchResultTranslator();
    }
}

