/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.WildcardQuery;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseWildcardQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testWildcardQuery() {
        for (int i = 0; i < 10; ++i) {
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "SomeUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "OtherUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "Other" + i));
        }
        this.assertSearch(indexingTestHelper -> {
            WildcardQuery wildcardQuery = this.queries.wildcard("userName", "Oth*ser*");
            SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
            searchSearchRequest.setIndexNames(new String[]{"_all"});
            searchSearchRequest.setQuery((Query)wildcardQuery);
            searchSearchRequest.setSize(Integer.valueOf(20));
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)10L, (long)searchHits.getTotalHits());
            List searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals((String)"Retrieved hits", (long)10L, (long)searchHitsList.size());
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                String userName = document.getString("userName");
                Assert.assertTrue((boolean)userName.startsWith("OtherUser"));
            });
        });
    }
}

