/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermsQuery;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.test.util.DocumentsAssert;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseTermsQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testTermsQuery() {
        Stream.of("alpha", "bravo", "charlie", "delta").forEach(userName -> this.addDocument(DocumentCreationHelpers.singleKeyword("userName", userName)));
        TermsQuery termsQuery = this.queries.terms("userName");
        termsQuery.addValues(new Object[]{"bravo", "charlie"});
        FieldSort sort = this.sorts.field("userName", SortOrder.DESC);
        String expected = "[charlie, bravo]";
        this.assertSearch(arg_0 -> BaseTermsQueryTestCase.lambda$testTermsQuery$3(termsQuery, (Sort)sort, expected, arg_0));
    }

    private static /* synthetic */ void lambda$testTermsQuery$3(TermsQuery termsQuery, Sort sort, String expected, BaseIndexingTestCase.IndexingTestHelper indexingTestHelper) {
        indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.query((Query)termsQuery).sorts(new Sort[]{sort}));
        indexingTestHelper.search();
        indexingTestHelper.verifyResponse(searchResponse -> {
            DocumentsAssert.assertValues(searchResponse.getRequestString(), searchResponse.getDocumentsStream(), "userName", expected);
            SearchHits searchHits = searchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)2L, (long)searchHits.getTotalHits());
        });
    }
}

