/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.query;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.SimpleStringQuery;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSimpleStringQueryTestCase
extends BaseIndexingTestCase {
    @Test
    public void testSimpleStringQuery() {
        for (int i = 0; i < 10; ++i) {
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "SomeUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "OtherUser" + i));
            this.addDocument(DocumentCreationHelpers.singleKeyword("userName", "Other" + i));
        }
        final SimpleStringQuery simpleStringQuery = this.queries.simpleString("(SomeUser* | OtherUser*)");
        simpleStringQuery.addField("userName", 1.0f);
        this.assertSearch(indexingTestHelper -> {
            SearchEngineAdapter searchEngineAdapter = this.getSearchEngineAdapter();
            SearchSearchResponse searchSearchResponse = (SearchSearchResponse)searchEngineAdapter.execute((SearchRequest)new SearchSearchRequest(){
                {
                    this.addSorts(new Sort[]{BaseSimpleStringQueryTestCase.this.sorts.field("userName")});
                    this.setIndexNames(new String[]{"_all"});
                    this.setQuery((Query)simpleStringQuery);
                    this.setSize(30);
                }
            });
            SearchHits searchHits = searchSearchResponse.getSearchHits();
            Assert.assertEquals((String)"Total hits", (long)20L, (long)searchHits.getTotalHits());
            List searchHitsList = searchHits.getSearchHits();
            Assert.assertEquals((String)"Retrieved hits", (long)20L, (long)searchHitsList.size());
            searchHitsList.forEach(searchHit -> {
                Document document = searchHit.getDocument();
                String userName = document.getString("userName");
                Assert.assertTrue((userName.startsWith("OtherUser") || userName.startsWith("SomeUser") ? 1 : 0) != 0);
            });
        });
    }
}

