/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.metrics.PercentileRanksAggregation;
import com.liferay.portal.search.aggregation.metrics.PercentileRanksAggregationResult;
import com.liferay.portal.search.aggregation.metrics.PercentilesMethod;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BasePercentileRanksAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testPercentileRanksAggregationHDR() throws Exception {
        this.index(10, 10, 10, 10, 20, 30, 40, 50);
        this.assertPercentileRanks(PercentilesMethod.HDR, new double[]{10.0, 20.0, 30.0, 40.0, 50.0}, "{10.0=50.0, 20.0=62.5, 30.0=75.0, 40.0=87.5, 50.0=100.0}");
    }

    @Test
    public void testPercentileRanksAggregationTDigest() throws Exception {
        this.index(10, 10, 10, 10, 20, 30, 40, 50);
        this.assertPercentileRanks(PercentilesMethod.TDIGEST, new double[]{10.0, 20.0, 30.0, 40.0, 50.0}, "{10.0=37.5, 20.0=56.25, 30.0=68.75, 40.0=81.25, 50.0=100.0}");
    }

    protected void assertPercentileRanks(PercentilesMethod percentilesMethod, double[] values, String expected) {
        PercentileRanksAggregation percentileRanksAggregation = this.aggregations.percentileRanks("percentileRanks", "priority", values);
        percentileRanksAggregation.setPercentilesMethod(percentilesMethod);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)percentileRanksAggregation));
            indexingTestHelper.search();
            PercentileRanksAggregationResult percentileRanksAggregationResult = (PercentileRanksAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)percentileRanksAggregation);
            Assert.assertEquals((Object)expected, (Object)String.valueOf(percentileRanksAggregationResult.getPercentiles()));
        });
    }

    protected void index(int ... values) {
        for (int value : values) {
            this.addDocument(DocumentCreationHelpers.singleNumber("priority", value));
        }
    }
}

