/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.metrics.GeoCentroidAggregation;
import com.liferay.portal.search.aggregation.metrics.GeoCentroidAggregationResult;
import com.liferay.portal.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseGeoCentroidAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testGeoCentroidAggregation() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.374081, 4.91235));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.369219, 4.901618));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 52.371667, 4.914722));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 51.2229, 4.4052));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.861111, 2.336389));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.86, 2.327));
        GeoCentroidAggregation geoBoundsAggregation = this.aggregations.geoCentroid("geoCentroid", "geoLocation");
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)geoBoundsAggregation));
            indexingTestHelper.search();
            GeoCentroidAggregationResult geoCentroidAggregationResult = (GeoCentroidAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)geoBoundsAggregation);
            Assert.assertNotNull((Object)geoCentroidAggregationResult);
            Assert.assertEquals((long)6L, (long)geoCentroidAggregationResult.getCount());
            GeoLocationPoint geoLocationPoint = geoCentroidAggregationResult.getCentroid();
            Assert.assertEquals((double)51.009829603135586, (double)geoLocationPoint.getLatitude(), (double)0.0);
            Assert.assertEquals((double)3.9662130642682314, (double)geoLocationPoint.getLongitude(), (double)0.0);
        });
    }
}

