/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.metrics;

import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.metrics.GeoBoundsAggregation;
import com.liferay.portal.search.aggregation.metrics.GeoBoundsAggregationResult;
import com.liferay.portal.search.geolocation.GeoLocationPoint;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseGeoBoundsAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testGeoBoundsAggregation() throws Exception {
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.861111, 2.336389));
        this.addDocument(DocumentCreationHelpers.singleGeoLocation("geoLocation", 48.86, 2.327));
        GeoBoundsAggregation geoBoundsAggregation = this.aggregations.geoBounds("geoBounds", "geoLocation");
        geoBoundsAggregation.setWrapLongitude(Boolean.valueOf(true));
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)geoBoundsAggregation));
            indexingTestHelper.search();
            GeoBoundsAggregationResult geoBoundsAggregationResult = (GeoBoundsAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)geoBoundsAggregation);
            Assert.assertNotNull((Object)geoBoundsAggregationResult);
            GeoLocationPoint bottomRightGeoLocationPoint = geoBoundsAggregationResult.getBottomRight();
            Assert.assertNotNull((Object)bottomRightGeoLocationPoint);
            Assert.assertEquals((double)48.85999997612089, (double)bottomRightGeoLocationPoint.getLatitude(), (double)0.0);
            Assert.assertEquals((double)2.3363889567553997, (double)bottomRightGeoLocationPoint.getLongitude(), (double)0.0);
            GeoLocationPoint topLeftGeoLocationPoint = geoBoundsAggregationResult.getTopLeft();
            Assert.assertNotNull((Object)topLeftGeoLocationPoint);
            Assert.assertEquals((double)48.86111099738628, (double)topLeftGeoLocationPoint.getLatitude(), (double)0.0);
            Assert.assertEquals((double)2.3269999679178, (double)topLeftGeoLocationPoint.getLongitude(), (double)0.0);
        });
    }
}

