/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.test.util.aggregation.bucket;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.bucket.MissingAggregation;
import com.liferay.portal.search.aggregation.bucket.MissingAggregationResult;
import com.liferay.portal.search.aggregation.metrics.SumAggregation;
import com.liferay.portal.search.aggregation.metrics.SumAggregationResult;
import com.liferay.portal.search.test.util.indexing.BaseIndexingTestCase;
import com.liferay.portal.search.test.util.indexing.DocumentCreationHelpers;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseMissingAggregationTestCase
extends BaseIndexingTestCase {
    @Test
    public void testMissing() throws Exception {
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 1);
        });
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 2);
        });
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "SomeUser1");
            document.addNumber("priority", 3);
        });
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 4);
        });
        this.addDocument((Document document) -> {
            document.addKeyword("userName", "SomeUser2");
            document.addNumber("priority", 5);
        });
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 6.0));
        this.addDocument(DocumentCreationHelpers.singleNumber("priority", 7.0));
        MissingAggregation missingAggregation = this.aggregations.missing("missing", "userName");
        SumAggregation sumAggregation = this.aggregations.sum("sum", "priority");
        missingAggregation.addChildAggregation((Aggregation)sumAggregation);
        this.assertSearch(indexingTestHelper -> {
            indexingTestHelper.defineRequest(searchRequestBuilder -> searchRequestBuilder.addAggregation((Aggregation)missingAggregation));
            indexingTestHelper.search();
            MissingAggregationResult missingAggregationResult = (MissingAggregationResult)indexingTestHelper.getAggregationResult((Aggregation)missingAggregation);
            Assert.assertEquals((String)"Documents missing user name", (long)2L, (long)missingAggregationResult.getDocCount());
            SumAggregationResult sumAggregationResult = (SumAggregationResult)missingAggregationResult.getChildAggregationResult(sumAggregation.getName());
            Assert.assertEquals((String)"SumUser1 total priorities", (double)13.0, (double)sumAggregationResult.getValue(), (double)0.0);
        });
    }
}

